/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.repository.AbstractExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepository;

@Component
@Singleton
@Named(value="xwiki")
public class XWikiExtensionRepositoryFactory
extends AbstractExtensionRepositoryFactory
implements Initializable {
    @Inject
    private ExtensionLicenseManager licenseManager;
    @Inject
    private ExtensionManagerConfiguration configuration;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public void initialize() throws InitializationException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.xwiki.extension.repository.xwiki.model.jaxb");
            this.marshaller = context.createMarshaller();
            this.unmarshaller = context.createUnmarshaller();
        }
        catch (Exception e) {
            throw new InitializationException("Failed to create JAXB context", (Throwable)e);
        }
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public ExtensionRepository createRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        try {
            return new XWikiExtensionRepository(repositoryDescriptor, this, this.licenseManager, this.configuration);
        }
        catch (Exception e) {
            throw new ExtensionRepositoryException("Failed to create repository [" + repositoryDescriptor + "]", (Throwable)e);
        }
    }
}

