/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionFile;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepository;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersion;
import org.xwiki.extension.repository.xwiki.model.jaxb.License;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;

public class XWikiExtension
extends AbstractExtension {
    public XWikiExtension(XWikiExtensionRepository repository, ExtensionVersion extension, ExtensionLicenseManager licenseManager) {
        super((ExtensionRepository)repository, new ExtensionId(extension.getId(), extension.getVersion()), extension.getType());
        this.setName(extension.getName());
        this.setSummary(extension.getSummary());
        this.setDescription(extension.getDescription());
        this.setWebsite(extension.getWebsite());
        this.setFeatures(extension.getFeatures());
        for (org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionAuthor author : extension.getAuthors()) {
            URL url;
            try {
                url = new URL(author.getUrl());
            }
            catch (MalformedURLException e) {
                url = null;
            }
            this.addAuthor((ExtensionAuthor)new DefaultExtensionAuthor(author.getName(), url));
        }
        for (License license : extension.getLicenses()) {
            if (license.getName() == null) continue;
            ExtensionLicense extensionLicense = licenseManager.getLicense(license.getName());
            if (extensionLicense != null) {
                this.addLicense(extensionLicense);
                continue;
            }
            List content = null;
            if (license.getContent() != null) {
                try {
                    content = IOUtils.readLines((Reader)new StringReader(license.getContent()));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.addLicense(new ExtensionLicense(license.getName(), content));
        }
        for (org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionDependency dependency : extension.getDependencies()) {
            this.addDependency((ExtensionDependency)new DefaultExtensionDependency(dependency.getId(), (VersionConstraint)new DefaultVersionConstraint(dependency.getConstraint())));
        }
        this.setFile(new XWikiExtensionFile(repository, this.getId()));
    }

    public XWikiExtensionRepository getRepository() {
        return (XWikiExtensionRepository)super.getRepository();
    }
}

