/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepository;

public class XWikiExtensionFile
implements ExtensionFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiExtensionFile.class);
    private XWikiExtensionRepository repository;
    private ExtensionId id;

    public XWikiExtensionFile(XWikiExtensionRepository repository, ExtensionId id) {
        this.repository = repository;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() {
        long l;
        CloseableHttpResponse response = null;
        try {
            try {
                response = this.repository.getRESTResource(this.repository.getExtensionFileUriBuider(), this.id.getId(), this.id.getVersion().getValue());
            }
            catch (IOException e2) {
                throw new RuntimeException(String.format("Failed to access extension [%s]", this), e2);
            }
            HttpEntity entity = response.getEntity();
            l = entity.getContentLength();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(response, e -> LOGGER.warn("Failed to close response after accessing extension [{}]. Root error: [{}]", (Object)this, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e)));
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)response, e -> LOGGER.warn("Failed to close response after accessing extension [{}]. Root error: [{}]", (Object)this, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e)));
        return l;
    }

    public InputStream openStream() throws IOException {
        CloseableHttpResponse response = this.repository.getRESTResource(this.repository.getExtensionFileUriBuider(), this.id.getId(), this.id.getVersion().getValue());
        return new XWikiExtensionFileInputStream(response);
    }

    static class XWikiExtensionFileInputStream
    extends FilterInputStream {
        private CloseableHttpResponse response;

        public XWikiExtensionFileInputStream(CloseableHttpResponse response) throws IllegalStateException, IOException {
            super(response.getEntity().getContent());
            this.response = response;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.response.close();
            }
        }
    }
}

