/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepository;

public class XWikiExtensionFile
implements ExtensionFile {
    private XWikiExtensionRepository repository;
    private ExtensionId id;

    public XWikiExtensionFile(XWikiExtensionRepository repository, ExtensionId id) {
        this.repository = repository;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() {
        CloseableHttpResponse response;
        try {
            response = this.repository.getRESTResource(this.repository.getExtensionFileUriBuider(), this.id.getId(), this.id.getVersion().getValue());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to acess extension [" + String.valueOf(this) + "]", e);
        }
        HttpEntity entity = response.getEntity();
        try {
            long l = entity.getContentLength();
            return l;
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    public InputStream openStream() throws IOException {
        CloseableHttpResponse response = this.repository.getRESTResource(this.repository.getExtensionFileUriBuider(), this.id.getId(), this.id.getVersion().getValue());
        return new XWikiExtensionFileInputStream(response);
    }

    static class XWikiExtensionFileInputStream
    extends FilterInputStream {
        private CloseableHttpResponse response;

        public XWikiExtensionFileInputStream(CloseableHttpResponse response) throws IllegalStateException, IOException {
            super(response.getEntity().getContent());
            this.response = response;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.response.close();
        }
    }
}

