/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.repository.AbstractExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.http.internal.HttpClientFactory;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepository;

@Component
@Singleton
@Named(value="xwiki")
public class XWikiExtensionRepositoryFactory
extends AbstractExtensionRepositoryFactory
implements Initializable {
    @Inject
    private ExtensionLicenseManager licenseManager;
    @Inject
    private HttpClientFactory httpClientFactory;
    @Inject
    private ExtensionFactory factory;
    private JAXBContext jaxbContext;

    public void initialize() throws InitializationException {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"org.xwiki.extension.repository.xwiki.model.jaxb");
        }
        catch (JAXBException e) {
            throw new InitializationException("Failed to create JAXB context", (Throwable)e);
        }
    }

    public Marshaller createMarshaller() throws JAXBException {
        return this.jaxbContext.createMarshaller();
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        return this.jaxbContext.createUnmarshaller();
    }

    public ExtensionRepository createRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        try {
            return new XWikiExtensionRepository(repositoryDescriptor, this, this.licenseManager, this.httpClientFactory, this.factory);
        }
        catch (Exception e) {
            throw new ExtensionRepositoryException("Failed to create repository [" + repositoryDescriptor + "]", (Throwable)e);
        }
    }
}

