/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.AbstractRatingExtension;
import org.xwiki.extension.DefaultExtensionScm;
import org.xwiki.extension.DefaultExtensionScmConnection;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.ExtensionScmConnection;
import org.xwiki.extension.MutableExtension;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.internal.converter.ExtensionComponentConverter;
import org.xwiki.extension.rating.DefaultExtensionRating;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.rating.RatableExtensionRepository;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionDependency;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionFile;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepository;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionAuthor;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionDependency;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionIssueManagement;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionRating;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersion;
import org.xwiki.extension.repository.xwiki.model.jaxb.License;
import org.xwiki.extension.repository.xwiki.model.jaxb.Namespaces;
import org.xwiki.extension.repository.xwiki.model.jaxb.Property;

public class XWikiExtension
extends AbstractRatingExtension {
    public XWikiExtension(XWikiExtensionRepository repository, ExtensionVersion restExtension, ExtensionLicenseManager licenseManager, ExtensionFactory factory) {
        super((ExtensionRepository)repository, new ExtensionId(restExtension.getId(), factory.getVersion(restExtension.getVersion())), restExtension.getType());
        Boolean recommended;
        ExtensionIssueManagement restIssueManagement;
        this.setName(restExtension.getName());
        this.setSummary(restExtension.getSummary());
        this.setWebsite(restExtension.getWebsite());
        this.setDescription(restExtension.getDescription());
        for (Object feature : restExtension.getExtensionFeatures()) {
            this.addExtensionFeature(new ExtensionId(feature.getId(), feature.getVersion() != null ? factory.getVersion(feature.getVersion()) : this.getId().getVersion()));
        }
        ExtensionRating restRating = restExtension.getRating();
        if (restRating != null) {
            this.setRating((org.xwiki.extension.rating.ExtensionRating)new DefaultExtensionRating(restRating.getTotalVotes(), restRating.getAverageVote(), (RatableExtensionRepository)this.getRepository()));
        }
        for (ExtensionAuthor restAuthor : restExtension.getAuthors()) {
            this.addAuthor(factory.getExtensionAuthor(restAuthor.getName(), restAuthor.getUrl()));
        }
        for (License restLicense : restExtension.getLicenses()) {
            if (restLicense.getName() == null) continue;
            ExtensionLicense extensionLicense = licenseManager.getLicense(restLicense.getName());
            if (extensionLicense != null) {
                this.addLicense(extensionLicense);
                continue;
            }
            List content = null;
            if (restLicense.getContent() != null) {
                try {
                    content = IOUtils.readLines((Reader)new StringReader(restLicense.getContent()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.addLicense(new ExtensionLicense(restLicense.getName(), content));
        }
        org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionScm restSCM = restExtension.getScm();
        if (restSCM != null) {
            DefaultExtensionScmConnection connection = XWikiExtension.toDefaultExtensionScmConnection(restSCM.getConnection());
            DefaultExtensionScmConnection developerConnection = XWikiExtension.toDefaultExtensionScmConnection(restSCM.getDeveloperConnection());
            this.setScm((ExtensionScm)new DefaultExtensionScm(restSCM.getUrl(), (ExtensionScmConnection)connection, (ExtensionScmConnection)developerConnection));
        }
        if ((restIssueManagement = restExtension.getIssueManagement()) != null) {
            this.setIssueManagement(factory.getExtensionIssueManagement(restIssueManagement.getSystem(), restIssueManagement.getUrl()));
        }
        this.setCategory(restExtension.getCategory());
        Namespaces namespaces = restExtension.getAllowedNamespaces();
        if (namespaces != null) {
            this.setAllowedNamespaces(namespaces.getNamespaces());
        }
        if ((recommended = restExtension.isRecommended()) != null) {
            this.setRecommended(restExtension.isRecommended());
        }
        for (Property restProperty : restExtension.getProperties()) {
            this.putProperty(restProperty.getKey(), restProperty.getStringValue());
        }
        if (repository != null) {
            this.addRepository(repository.getDescriptor());
        }
        for (org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionRepository restRepository : restExtension.getRepositories()) {
            try {
                this.addRepository(XWikiExtension.toExtensionRepositoryDescriptor(restRepository, factory));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        this.setDependencies(this.toXWikiExtensionDependencies(restExtension.getDependencies(), factory));
        this.setManagedDependencies(this.toXWikiExtensionDependencies(restExtension.getManagedDependencies(), factory));
        if (StringUtils.isNotEmpty((CharSequence)this.getType())) {
            this.setFile(new XWikiExtensionFile(repository, this.getId()));
        }
        this.setName(ExtensionUtils.importProperty((MutableExtension)this, (String)"name", (String)this.getName()));
        this.setSummary(ExtensionUtils.importProperty((MutableExtension)this, (String)"summary", (String)this.getSummary()));
        this.setWebsite(ExtensionUtils.importProperty((MutableExtension)this, (String)"website", (String)this.getWebSite()));
        this.setAllowedNamespaces(ExtensionUtils.importProperty((MutableExtension)this, (String)"namespaces", (Collection)this.getAllowedNamespaces()));
        String componentsString = (String)ExtensionUtils.importProperty((MutableExtension)this, (String)"components");
        if (StringUtils.isNotBlank((CharSequence)componentsString)) {
            List components = ExtensionUtils.importPropertyStringList((String)componentsString, (boolean)true, (int[])ExtensionUtils.CLASS_DELIMITERS);
            this.setComponents(ExtensionComponentConverter.toExtensionComponentList((Collection)components));
        }
    }

    private Collection<XWikiExtensionDependency> toXWikiExtensionDependencies(List<ExtensionDependency> restDependencies, ExtensionFactory factory) {
        ArrayList<XWikiExtensionDependency> newDependencies = new ArrayList<XWikiExtensionDependency>(restDependencies.size());
        for (ExtensionDependency dependency : restDependencies) {
            newDependencies.add(new XWikiExtensionDependency(dependency, this.repository != null ? this.repository.getDescriptor() : null, factory));
        }
        return newDependencies;
    }

    protected static DefaultExtensionScmConnection toDefaultExtensionScmConnection(org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionScmConnection connection) {
        if (connection != null) {
            return new DefaultExtensionScmConnection(connection.getSystem(), connection.getPath());
        }
        return null;
    }

    protected static ExtensionRepositoryDescriptor toExtensionRepositoryDescriptor(org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionRepository restRepository, ExtensionFactory factory) throws URISyntaxException {
        return factory.getExtensionRepositoryDescriptor(restRepository.getId(), restRepository.getType(), new URI(restRepository.getUri()), null);
    }

    public XWikiExtensionRepository getRepository() {
        return (XWikiExtensionRepository)super.getRepository();
    }
}

