/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionNotFoundException;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.rating.ExtensionRating;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.http.internal.HttpClientFactory;
import org.xwiki.extension.repository.rating.RatableExtensionRepository;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.AdvancedSearchable;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.xwiki.internal.ResourceNotFoundException;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtension;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepositoryFactory;
import org.xwiki.extension.repository.xwiki.model.jaxb.COMPARISON;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersion;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersionSummary;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersions;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionsSearchResult;
import org.xwiki.extension.repository.xwiki.model.jaxb.Filter;
import org.xwiki.extension.repository.xwiki.model.jaxb.ORDER;
import org.xwiki.extension.repository.xwiki.model.jaxb.ObjectFactory;
import org.xwiki.extension.repository.xwiki.model.jaxb.Repository;
import org.xwiki.extension.repository.xwiki.model.jaxb.SortClause;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.VersionUtils;
import org.xwiki.repository.UriBuilder;

public class XWikiExtensionRepository
extends AbstractExtensionRepository
implements AdvancedSearchable,
RatableExtensionRepository {
    public static final Version VERSION10 = new DefaultVersion("1.0");
    public static final Version VERSION11 = new DefaultVersion("1.1");
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiExtensionRepository.class);
    private static final ObjectFactory EXTENSION_OBJECT_FACTORY = new ObjectFactory();
    private final transient XWikiExtensionRepositoryFactory repositoryFactory;
    private final transient ExtensionLicenseManager licenseManager;
    private final transient HttpClientFactory httpClientFactory;
    private final transient ExtensionFactory factory;
    private final transient UriBuilder rootUriBuider;
    private final transient UriBuilder extensionVersionUriBuider;
    private final transient UriBuilder extensionVersionFileUriBuider;
    private final transient UriBuilder extensionVersionsUriBuider;
    private final transient UriBuilder searchUriBuider;
    private HttpClientContext localContext;
    private Version repositoryVersion;
    private boolean filterable;
    private boolean sortable;

    public XWikiExtensionRepository(ExtensionRepositoryDescriptor repositoryDescriptor, XWikiExtensionRepositoryFactory repositoryFactory, ExtensionLicenseManager licenseManager, HttpClientFactory httpClientFactory, ExtensionFactory factory) throws Exception {
        super((ExtensionRepositoryDescriptor)(repositoryDescriptor.getURI().getPath().endsWith("/") ? new DefaultExtensionRepositoryDescriptor(repositoryDescriptor.getId(), repositoryDescriptor.getType(), new URI(StringUtils.chop((String)repositoryDescriptor.getURI().toString())), repositoryDescriptor.getProperties()) : repositoryDescriptor));
        this.repositoryFactory = repositoryFactory;
        this.licenseManager = licenseManager;
        this.httpClientFactory = httpClientFactory;
        this.factory = factory;
        this.rootUriBuider = this.createUriBuilder("/repository");
        this.extensionVersionUriBuider = this.createUriBuilder("/repository/extensions/{extensionId}/versions/{extensionVersion}");
        this.extensionVersionFileUriBuider = this.createUriBuilder("/repository/extensions/{extensionId}/versions/{extensionVersion}/file");
        this.extensionVersionsUriBuider = this.createUriBuilder("/repository/extensions/{extensionId}/versions");
        this.searchUriBuider = this.createUriBuilder("/repository/search");
        if (this.getDescriptor().getProperty("auth.user") != null) {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(new HttpHost(this.getDescriptor().getURI().getHost(), this.getDescriptor().getURI().getPort(), this.getDescriptor().getURI().getScheme()), (AuthScheme)basicAuth);
            this.localContext = HttpClientContext.create();
            this.localContext.setAuthCache((AuthCache)authCache);
        }
    }

    private void initRepositoryFeatures() {
        if (this.repositoryVersion == null) {
            CloseableHttpResponse response;
            this.repositoryVersion = new DefaultVersion("1.0");
            this.filterable = false;
            this.sortable = false;
            try {
                response = this.getRESTResource(this.rootUriBuider, new Object[0]);
            }
            catch (IOException e) {
                return;
            }
            try {
                Repository repository = (Repository)this.getRESTObject(response);
                this.repositoryVersion = new DefaultVersion(repository.getVersion());
                this.filterable = repository.isFilterable() == Boolean.TRUE;
                this.sortable = repository.isSortable() == Boolean.TRUE;
            }
            catch (Exception e) {
                LOGGER.error("Failed to get repository features", (Throwable)e);
            }
        }
    }

    public Version getRepositoryVersion() {
        this.initRepositoryFeatures();
        return this.repositoryVersion;
    }

    public boolean isFilterable() {
        this.initRepositoryFeatures();
        return this.filterable;
    }

    public boolean isSortable() {
        this.initRepositoryFeatures();
        return this.sortable;
    }

    protected UriBuilder getExtensionFileUriBuider() {
        return this.extensionVersionFileUriBuider;
    }

    protected CloseableHttpResponse getRESTResource(UriBuilder builder, Object ... values) throws IOException {
        CloseableHttpResponse response;
        String url;
        try {
            url = builder.build(values).toString();
        }
        catch (Exception e) {
            throw new IOException("Failed to build REST URL", e);
        }
        CloseableHttpClient httpClient = this.httpClientFactory.createClient(this.getDescriptor().getProperty("auth.user"), this.getDescriptor().getProperty("auth.password"));
        HttpGet getMethod = new HttpGet(url);
        getMethod.addHeader("Accept", "application/xml");
        try {
            response = this.localContext != null ? httpClient.execute((HttpUriRequest)getMethod, (HttpContext)this.localContext) : httpClient.execute((HttpUriRequest)getMethod);
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to request [%s]", getMethod.getURI()), e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            if (response.getStatusLine().getStatusCode() == 404) {
                throw new ResourceNotFoundException(String.format("Resource with URI [%s] does not exist", getMethod.getURI()));
            }
            throw new IOException(String.format("Invalid answer [%s] from the server when requesting [%s]", response.getStatusLine().getStatusCode(), getMethod.getURI()));
        }
        return response;
    }

    protected CloseableHttpResponse postRESTResource(UriBuilder builder, String content, Object ... values) throws IOException {
        CloseableHttpResponse response;
        String url;
        try {
            url = builder.build(values).toString();
        }
        catch (Exception e) {
            throw new IOException("Failed to build REST URL", e);
        }
        CloseableHttpClient httpClient = this.httpClientFactory.createClient(this.getDescriptor().getProperty("auth.user"), this.getDescriptor().getProperty("auth.password"));
        HttpPost postMethod = new HttpPost(url);
        postMethod.addHeader("Accept", "application/xml");
        StringEntity entity = new StringEntity(content, ContentType.create((String)ContentType.APPLICATION_XML.getMimeType(), (Charset)Consts.UTF_8));
        postMethod.setEntity((HttpEntity)entity);
        try {
            response = this.localContext != null ? httpClient.execute((HttpUriRequest)postMethod, (HttpContext)this.localContext) : httpClient.execute((HttpUriRequest)postMethod);
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to request [%s]", postMethod.getURI()), e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException(String.format("Invalid answer [%s] from the server when requesting [%s]", response.getStatusLine().getStatusCode(), postMethod.getURI()));
        }
        return response;
    }

    protected Object getRESTObject(UriBuilder builder, Object ... values) throws IllegalStateException, IOException, JAXBException {
        return this.getRESTObject(this.getRESTResource(builder, values));
    }

    protected Object postRESTObject(UriBuilder builder, Object restObject, Object ... values) throws IllegalStateException, IOException, JAXBException {
        StringWriter writer = new StringWriter();
        this.repositoryFactory.createMarshaller().marshal(restObject, (Writer)writer);
        return this.getRESTObject(this.postRESTResource(builder, writer.toString(), values));
    }

    /*
     * Loose catch block
     */
    protected <T> T getRESTObject(CloseableHttpResponse response) throws IllegalStateException, IOException, JAXBException {
        try {
            Object object;
            try (InputStream inputStream = response.getEntity().getContent();){
                object = this.repositoryFactory.createUnmarshaller().unmarshal(inputStream);
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            response.close();
        }
    }

    private UriBuilder createUriBuilder(String path) {
        return new UriBuilder(this.getDescriptor().getURI(), path);
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        try {
            return this.resolve(extensionId.getId(), extensionId.getVersion());
        }
        catch (ResourceNotFoundException e) {
            throw new ExtensionNotFoundException("Could not find extension [" + extensionId + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to create extension object for extension [" + extensionId + "]", (Throwable)e);
        }
    }

    private Extension resolve(String id, Version version) throws IllegalStateException, IOException, JAXBException {
        return new XWikiExtension(this, (ExtensionVersion)this.getRESTObject(this.extensionVersionUriBuider, id, version), this.licenseManager, this.factory);
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        try {
            Version version = this.resolveVersionConstraint(extensionDependency.getId(), extensionDependency.getVersionConstraint());
            return this.resolve(extensionDependency.getId(), version);
        }
        catch (ResourceNotFoundException e) {
            throw new ExtensionNotFoundException("Could not find any extension to match dependency [" + extensionDependency + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to create extension object for extension dependency [" + extensionDependency + "]", (Throwable)e);
        }
    }

    private Version resolveVersionConstraint(String id, VersionConstraint versionConstraint) throws ResolveException {
        if (versionConstraint.getVersion() != null) {
            return versionConstraint.getVersion();
        }
        Version strictVersion = VersionUtils.getStrictVersion((Collection)versionConstraint.getRanges());
        if (strictVersion != null) {
            return strictVersion;
        }
        ExtensionVersions versions = this.resolveExtensionVersions(id, versionConstraint, 0, -1, false);
        if (versions.getExtensionVersionSummaries().isEmpty()) {
            throw new ExtensionNotFoundException("Can't find any version with id [" + id + "] matching version constraint [" + versionConstraint + "]");
        }
        return new DefaultVersion(((ExtensionVersionSummary)versions.getExtensionVersionSummaries().get(versions.getExtensionVersionSummaries().size() - 1)).getVersion());
    }

    private ExtensionVersions resolveExtensionVersions(String id, VersionConstraint constraint, int offset, int nb, boolean requireTotalHits) throws ResolveException {
        UriBuilder builder = this.extensionVersionsUriBuider.clone();
        builder.queryParam("requireTotalHits", new Object[]{requireTotalHits});
        builder.queryParam("start", new Object[]{offset});
        builder.queryParam("number", new Object[]{nb});
        if (constraint != null) {
            builder.queryParam("versionRanges", new Object[]{constraint.getValue()});
        }
        try {
            return (ExtensionVersions)this.getRESTObject(builder, id);
        }
        catch (ResourceNotFoundException e) {
            throw new ExtensionNotFoundException("Could not find extension with id [" + id + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to find version for extension id [" + id + "]", (Throwable)e);
        }
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        ExtensionVersions restExtensions = this.resolveExtensionVersions(id, null, offset, nb, true);
        ArrayList<DefaultVersion> versions = new ArrayList<DefaultVersion>(restExtensions.getExtensionVersionSummaries().size());
        for (ExtensionVersionSummary restExtension : restExtensions.getExtensionVersionSummaries()) {
            versions.add(new DefaultVersion(restExtension.getVersion()));
        }
        return new CollectionIterableResult(restExtensions.getTotalHits(), restExtensions.getOffset(), versions);
    }

    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        ExtensionsSearchResult restExtensions;
        UriBuilder builder = this.searchUriBuider.clone();
        builder.queryParam("start", new Object[]{offset});
        builder.queryParam("number", new Object[]{nb});
        if (pattern != null) {
            builder.queryParam("q", new Object[]{pattern});
        }
        try {
            restExtensions = (ExtensionsSearchResult)this.getRESTObject(builder, new Object[0]);
        }
        catch (Exception e) {
            throw new SearchException("Failed to search extensions based on pattern [" + pattern + "]", (Throwable)e);
        }
        ArrayList<XWikiExtension> extensions = new ArrayList<XWikiExtension>(restExtensions.getExtensions().size());
        for (ExtensionVersion restExtension : restExtensions.getExtensions()) {
            extensions.add(new XWikiExtension(this, restExtension, this.licenseManager, this.factory));
        }
        return new CollectionIterableResult(restExtensions.getTotalHits(), restExtensions.getOffset(), extensions);
    }

    public IterableResult<Extension> search(ExtensionQuery query) throws SearchException {
        ExtensionsSearchResult restExtensions;
        if (this.getRepositoryVersion().equals(VERSION10)) {
            return this.search(query.getQuery(), query.getOffset(), query.getLimit());
        }
        UriBuilder builder = this.searchUriBuider.clone();
        org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionQuery restQuery = EXTENSION_OBJECT_FACTORY.createExtensionQuery();
        restQuery.setQuery(query.getQuery());
        restQuery.setOffset(query.getOffset());
        restQuery.setLimit(query.getLimit());
        for (ExtensionQuery.Filter filter : query.getFilters()) {
            Filter restFilter = EXTENSION_OBJECT_FACTORY.createFilter();
            restFilter.setField(filter.getField());
            restFilter.setValueString(filter.getValue().toString());
            restFilter.setComparison(COMPARISON.fromValue((String)filter.getComparison().name()));
            restQuery.getFilters().add(restFilter);
        }
        for (ExtensionQuery.SortClause sortClause : query.getSortClauses()) {
            SortClause restSortClause = EXTENSION_OBJECT_FACTORY.createSortClause();
            restSortClause.setField(sortClause.getField());
            restSortClause.setOrder(ORDER.fromValue((String)sortClause.getOrder().name()));
            restQuery.getSortClauses().add(restSortClause);
        }
        try {
            restExtensions = (ExtensionsSearchResult)this.postRESTObject(builder, restQuery, new Object[0]);
        }
        catch (Exception e) {
            throw new SearchException("Failed to search extensions based on pattern [" + query.getQuery() + "]", (Throwable)e);
        }
        ArrayList<XWikiExtension> extensions = new ArrayList<XWikiExtension>(restExtensions.getExtensions().size());
        for (ExtensionVersion restExtension : restExtensions.getExtensions()) {
            extensions.add(new XWikiExtension(this, restExtension, this.licenseManager, this.factory));
        }
        return new CollectionIterableResult(restExtensions.getTotalHits(), restExtensions.getOffset(), extensions);
    }

    public ExtensionRating getRating(ExtensionId extensionId) throws ResolveException {
        return this.getRating(extensionId.getId(), extensionId.getVersion());
    }

    public ExtensionRating getRating(String extensionId, Version extensionVersion) throws ResolveException {
        return this.getRating(extensionId, extensionVersion.getValue());
    }

    public ExtensionRating getRating(String extensionId, String extensionVersion) throws ResolveException {
        try {
            return new XWikiExtension(this, (ExtensionVersion)this.getRESTObject(this.extensionVersionUriBuider, extensionId, extensionVersion), this.licenseManager, this.factory).getRating();
        }
        catch (ResourceNotFoundException e) {
            throw new ExtensionNotFoundException("Could not find extension with id [" + extensionId + "] and version [" + extensionVersion + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to create extension object for extension [" + extensionId + ":" + extensionVersion + "]", (Throwable)e);
        }
    }
}

