/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.repository.AbstractExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.XWikiRepositorySystemSession;

@Component
@Singleton
@Named(value="maven")
public class AetherExtensionRepositoryFactory
extends AbstractExtensionRepositoryFactory
implements Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<PlexusContainer> plexusProvider;
    @Inject
    private ExtensionManagerConfiguration configuration;
    private RepositorySystem repositorySystem;

    public void initialize() throws InitializationException {
        try {
            this.repositorySystem = (RepositorySystem)((PlexusContainer)this.plexusProvider.get()).lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to lookup RepositorySystem", (Throwable)e);
        }
    }

    public XWikiRepositorySystemSession createRepositorySystemSession() {
        XWikiRepositorySystemSession session = new XWikiRepositorySystemSession(this.repositorySystem);
        session.setUserAgent(this.configuration.getUserAgent());
        return session;
    }

    public ExtensionRepository createRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        try {
            RemoteRepository.Builder aetherRepositoryBuilder = new RemoteRepository.Builder(repositoryDescriptor.getId(), "default", repositoryDescriptor.getURI().toString());
            aetherRepositoryBuilder.setPolicy(new RepositoryPolicy(true, "always", "warn"));
            String username = repositoryDescriptor.getProperty("auth.user");
            if (username != null) {
                AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
                authenticationBuilder.addUsername(username);
                authenticationBuilder.addPassword(repositoryDescriptor.getProperty("auth.password"));
                aetherRepositoryBuilder.setAuthentication(authenticationBuilder.build());
            }
            Proxy proxy = XWikiRepositorySystemSession.JREPROXYSELECTOR.getProxy(aetherRepositoryBuilder.build());
            aetherRepositoryBuilder.setProxy(proxy);
            RemoteRepository aetherRepository = aetherRepositoryBuilder.build();
            return new AetherExtensionRepository(repositoryDescriptor, this, aetherRepository, (PlexusContainer)this.plexusProvider.get(), this.componentManager);
        }
        catch (Exception e) {
            throw new ExtensionRepositoryException("Failed to create repository [" + repositoryDescriptor + "]", (Throwable)e);
        }
    }
}

