/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.AbstractForwardingRepositorySystemSession;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

public class XWikiRepositorySystemSession
extends AbstractForwardingRepositorySystemSession
implements AutoCloseable {
    static final JreProxySelector JREPROXYSELECTOR = new JreProxySelector();
    private final DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();

    public XWikiRepositorySystemSession(RepositorySystem repositorySystem) {
        File localDir = Files.createTempDir();
        LocalRepository localRepository = new LocalRepository(localDir);
        this.session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)this.session, localRepository));
        this.session.setProxySelector((ProxySelector)JREPROXYSELECTOR);
        this.session.setSystemProperty("version", null);
        this.session.setSystemProperty("groupId", null);
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getArtifactTypeRegistry();
        if (artifactTypeRegistry instanceof DefaultArtifactTypeRegistry) {
            DefaultArtifactTypeRegistry defaultArtifactTypeRegistry = (DefaultArtifactTypeRegistry)artifactTypeRegistry;
            defaultArtifactTypeRegistry.add((ArtifactType)new DefaultArtifactType("bundle", "jar", "", "java"));
            defaultArtifactTypeRegistry.add((ArtifactType)new DefaultArtifactType("eclipse-plugin", "jar", "", "java"));
        }
        this.session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(false, false));
    }

    protected RepositorySystemSession getSession() {
        return this.session;
    }

    @Override
    public void close() {
        LocalRepository repository = this.session.getLocalRepository();
        if (repository.getBasedir().exists()) {
            try {
                FileUtils.deleteDirectory((File)repository.getBasedir());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setUserAgent(String userAgent) {
        this.session.setConfigProperty("aether.connector.userAgent", (Object)userAgent);
    }
}

