/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.aether.internal.AetherExtensionFile;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.AetherUtils;
import org.xwiki.extension.repository.internal.MavenExtension;

public class AetherExtension
extends AbstractExtension
implements MavenExtension {
    public static final String PKEY_AETHER_ATIFACT = "aether.Artifact";
    public static final String PKEY_MAVEN_MODEL = "maven.Model";

    public AetherExtension(Extension mavenExtension, Artifact artifact, AetherExtensionRepository repository) {
        super((ExtensionRepository)repository, mavenExtension);
        this.setId(AetherUtils.createExtensionId(artifact));
        this.setType(artifact.getExtension());
        this.setFile(new AetherExtensionFile(artifact, repository));
    }

    public Model getMavenModel() {
        return (Model)this.getProperty(PKEY_MAVEN_MODEL);
    }

    public String getMavenArtifactId() {
        return this.getMavenModel().getArtifactId();
    }

    public String getMavenGroupId() {
        return this.getMavenModel().getGroupId();
    }
}

