/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.apache.maven.repository.internal.PublicDefaultModelResolver;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionIssueManagement;
import org.xwiki.extension.DefaultExtensionScm;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.ExtensionScmConnection;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.aether.internal.AetherExtension;
import org.xwiki.extension.repository.aether.internal.AetherExtensionDependency;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepositoryFactory;
import org.xwiki.extension.repository.aether.internal.AetherUtils;
import org.xwiki.extension.repository.aether.internal.XWikiRepositorySystemSession;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.properties.ConverterManager;

public class AetherExtensionRepository
extends AbstractExtensionRepository {
    public static final String MPKEYPREFIX = "xwiki.extension.";
    public static final String MPNAME_NAME = "name";
    public static final String MPNAME_SUMMARY = "summary";
    public static final String MPNAME_WEBSITE = "website";
    public static final String MPNAME_FEATURES = "features";
    private static final GenericVersionScheme AETHERVERSIONSCHEME = new GenericVersionScheme();
    private transient PlexusContainer plexusContainer;
    private transient RemoteRepository remoteRepository;
    private transient ArtifactDescriptorReader mavenDescriptorReader;
    private transient VersionRangeResolver versionRangeResolver;
    private transient VersionResolver versionResolver;
    private transient ModelBuilder modelBuilder;
    private transient ArtifactResolver artifactResolver;
    private transient RepositorySystem repositorySystem;
    private transient RepositoryConnectorProvider repositoryConnectorProvider;
    private transient RemoteRepositoryManager remoteRepositoryManager;
    private transient ConverterManager converter;
    private transient ExtensionLicenseManager licenseManager;
    private transient AetherExtensionRepositoryFactory repositoryFactory;

    public AetherExtensionRepository(ExtensionRepositoryDescriptor repositoryDescriptor, AetherExtensionRepositoryFactory repositoryFactory, PlexusContainer plexusContainer, ComponentManager componentManager) throws Exception {
        super(repositoryDescriptor);
        this.repositoryFactory = repositoryFactory;
        this.plexusContainer = plexusContainer;
        RemoteRepository.Builder repositoryBuilder = new RemoteRepository.Builder(repositoryDescriptor.getId(), "default", repositoryDescriptor.getURI().toString());
        repositoryBuilder.setPolicy(new RepositoryPolicy(true, "always", "warn"));
        String username = this.getDescriptor().getProperty("auth.user");
        if (username != null) {
            AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
            authenticationBuilder.addUsername(username);
            authenticationBuilder.addPassword(this.getDescriptor().getProperty("auth.password"));
            repositoryBuilder.setAuthentication(authenticationBuilder.build());
        }
        Proxy proxy = XWikiRepositorySystemSession.JREPROXYSELECTOR.getProxy(repositoryBuilder.build());
        repositoryBuilder.setProxy(proxy);
        this.remoteRepository = repositoryBuilder.build();
        this.converter = (ConverterManager)componentManager.getInstance(ConverterManager.class);
        this.licenseManager = (ExtensionLicenseManager)componentManager.getInstance(ExtensionLicenseManager.class);
        this.versionRangeResolver = (VersionRangeResolver)this.plexusContainer.lookup(VersionRangeResolver.class);
        this.versionResolver = (VersionResolver)this.plexusContainer.lookup(VersionResolver.class);
        this.modelBuilder = (ModelBuilder)this.plexusContainer.lookup(ModelBuilder.class);
        this.artifactResolver = (ArtifactResolver)this.plexusContainer.lookup(ArtifactResolver.class);
        this.repositorySystem = (RepositorySystem)this.plexusContainer.lookup(RepositorySystem.class);
        this.mavenDescriptorReader = (ArtifactDescriptorReader)this.plexusContainer.lookup(ArtifactDescriptorReader.class);
        this.repositoryConnectorProvider = (RepositoryConnectorProvider)this.plexusContainer.lookup(RepositoryConnectorProvider.class);
        this.remoteRepositoryManager = (RemoteRepositoryManager)this.plexusContainer.lookup(RemoteRepositoryManager.class);
    }

    public RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public RepositoryConnectorProvider getRepositoryConnectorProvider() {
        return this.repositoryConnectorProvider;
    }

    protected XWikiRepositorySystemSession createRepositorySystemSession() {
        return this.repositoryFactory.createRepositorySystemSession();
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        if (this.getDescriptor().getType().equals("maven") && this.mavenDescriptorReader != null) {
            return this.resolveMaven(extensionId);
        }
        throw new ResolveException("Unsupported");
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        if (this.getDescriptor().getType().equals("maven") && this.mavenDescriptorReader != null) {
            return this.resolveMaven(extensionDependency);
        }
        throw new ResolveException("Unsupported");
    }

    public IterableResult<org.xwiki.extension.version.Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<Version> versions;
        DefaultArtifact artifact = AetherUtils.createArtifact(id, "(,)");
        try (XWikiRepositorySystemSession session = this.createRepositorySystemSession();){
            versions = this.resolveVersions((Artifact)artifact, (RepositorySystemSession)session);
            if (versions.isEmpty()) {
                throw new ResolveException("No versions available for id [" + id + "]");
            }
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve versions for id [" + id + "]", (Throwable)e);
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult(versions.size(), offset, Collections.emptyList());
        }
        int fromId = offset < 0 ? 0 : offset;
        int toId = offset + nb > versions.size() || nb < 0 ? versions.size() : offset + nb;
        ArrayList<DefaultVersion> result = new ArrayList<DefaultVersion>(toId - fromId);
        for (int i = fromId; i < toId; ++i) {
            result.add(new DefaultVersion(versions.get(i).toString()));
        }
        return new CollectionIterableResult(versions.size(), offset, result);
    }

    private Version resolveVersionConstraint(String id, VersionConstraint versionConstraint, RepositorySystemSession session) throws ResolveException {
        if (versionConstraint.getVersion() != null) {
            try {
                return AETHERVERSIONSCHEME.parseVersion(versionConstraint.getVersion().getValue());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new ResolveException("Invalid version [" + versionConstraint.getVersion() + "]", (Throwable)e);
            }
        }
        List commonVersions = null;
        for (VersionRange range : versionConstraint.getRanges()) {
            ArrayList versions = this.resolveVersionRange(id, range, session);
            if (commonVersions == null) {
                commonVersions = versionConstraint.getRanges().size() > 1 ? new ArrayList(versions) : versions;
                continue;
            }
            Iterator it = commonVersions.iterator();
            while (it.hasNext()) {
                Version version = (Version)it.next();
                if (versions.contains(version)) continue;
                it.remove();
            }
        }
        if (commonVersions == null || commonVersions.isEmpty()) {
            throw new ResolveException("No versions available for id [" + id + "] and version constraint [" + versionConstraint + "]");
        }
        return (Version)commonVersions.get(commonVersions.size() - 1);
    }

    private List<Version> resolveVersionRange(String id, VersionRange versionRange, RepositorySystemSession session) throws ResolveException {
        DefaultArtifact artifact = AetherUtils.createArtifact(id, versionRange.getValue());
        try {
            List<Version> versions = this.resolveVersions((Artifact)artifact, session);
            if (versions.isEmpty()) {
                throw new ResolveException("No versions available for id [" + id + "] and version range [" + versionRange + "]");
            }
            return versions;
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve version range", (Throwable)e);
        }
    }

    List<Version> resolveVersions(Artifact artifact, RepositorySystemSession session) throws VersionRangeResolutionException {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.newResolutionRepositories(session));
        VersionRangeResult rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
        return rangeResult.getVersions();
    }

    private String getProperty(Model model, String propertyName) {
        return model.getProperties().getProperty(MPKEYPREFIX + propertyName);
    }

    private String getPropertyString(Model model, String propertyName, String def) {
        return StringUtils.defaultString((String)this.getProperty(model, propertyName), (String)def);
    }

    private AetherExtension resolveMaven(ExtensionDependency extensionDependency) throws ResolveException {
        String artifactExtension;
        Artifact artifact;
        try (XWikiRepositorySystemSession session = this.createRepositorySystemSession();){
            if (extensionDependency instanceof AetherExtensionDependency) {
                artifact = ((AetherExtensionDependency)extensionDependency).getAetherDependency().getArtifact();
                artifactExtension = ((AetherExtensionDependency)extensionDependency).getAetherDependency().getArtifact().getExtension();
            } else {
                artifact = AetherUtils.createArtifact(extensionDependency.getId(), extensionDependency.getVersionConstraint().getValue());
                if (!extensionDependency.getVersionConstraint().getRanges().isEmpty()) {
                    artifact = artifact.setVersion(this.resolveVersionConstraint(extensionDependency.getId(), extensionDependency.getVersionConstraint(), (RepositorySystemSession)session).toString());
                }
                artifactExtension = null;
            }
        }
        return this.resolveMaven(artifact, artifactExtension);
    }

    private AetherExtension resolveMaven(ExtensionId extensionId) throws ResolveException {
        DefaultArtifact artifact = AetherUtils.createArtifact(extensionId.getId(), extensionId.getVersion().getValue());
        return this.resolveMaven((Artifact)artifact, null);
    }

    private AetherExtension resolveMaven(Artifact artifact, String artifactExtension) throws ResolveException {
        try (XWikiRepositorySystemSession session = this.createRepositorySystemSession();){
            AetherExtension aetherExtension = this.resolveMaven(artifact, artifactExtension, (RepositorySystemSession)session);
            return aetherExtension;
        }
    }

    private AetherExtension resolveMaven(Artifact artifact, String artifactExtension, RepositorySystemSession session) throws ResolveException {
        String featuresString;
        IssueManagement issueManagement;
        Model model;
        try {
            model = this.loadPom(artifact, session);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve artifact [" + artifact + "] descriptor", (Throwable)e);
        }
        if (model == null) {
            throw new ResolveException("Failed to resolve artifact [" + artifact + "] descriptor");
        }
        if (artifactExtension == null) {
            ArtifactType artifactType = session.getArtifactTypeRegistry().get(model.getPackaging());
            artifactExtension = artifactType != null ? artifactType.getExtension() : model.getPackaging();
        }
        DefaultArtifact filerArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifactExtension, artifact.getVersion());
        AetherExtension extension = new AetherExtension((Artifact)filerArtifact, model, this);
        extension.setName(this.getPropertyString(model, MPNAME_NAME, model.getName()));
        extension.setSummary(this.getPropertyString(model, MPNAME_SUMMARY, model.getDescription()));
        extension.setWebsite(this.getPropertyString(model, MPNAME_WEBSITE, model.getUrl()));
        for (Developer developer : model.getDevelopers()) {
            URL authorURL = null;
            if (developer.getUrl() != null) {
                try {
                    authorURL = new URL(developer.getUrl());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            extension.addAuthor((ExtensionAuthor)new DefaultExtensionAuthor((String)StringUtils.defaultIfBlank((CharSequence)developer.getName(), (CharSequence)developer.getId()), authorURL));
        }
        for (License license : model.getLicenses()) {
            extension.addLicense(this.getExtensionLicense(license));
        }
        Scm scm = model.getScm();
        if (scm != null) {
            ExtensionScmConnection connection = AetherUtils.toExtensionScmConnection(scm.getConnection());
            ExtensionScmConnection developerConnection = AetherUtils.toExtensionScmConnection(scm.getDeveloperConnection());
            extension.setScm((ExtensionScm)new DefaultExtensionScm(scm.getUrl(), connection, developerConnection));
        }
        if ((issueManagement = model.getIssueManagement()) != null) {
            extension.setIssueManagement((ExtensionIssueManagement)new DefaultExtensionIssueManagement(issueManagement.getSystem(), issueManagement.getUrl()));
        }
        if (StringUtils.isNotBlank((CharSequence)(featuresString = this.getProperty(model, MPNAME_FEATURES)))) {
            featuresString = featuresString.replaceAll("[\r\n]", "");
            extension.setFeatures((Collection)this.converter.convert(List.class, (Object)featuresString));
        }
        try {
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            for (Dependency mavenDependency : model.getDependencies()) {
                if (mavenDependency.isOptional() || !mavenDependency.getScope().equals("compile") && !mavenDependency.getScope().equals("runtime")) continue;
                extension.addDependency((ExtensionDependency)new AetherExtensionDependency(this.convertToAether(mavenDependency, stereotypes), mavenDependency));
            }
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve dependencies", (Throwable)e);
        }
        return extension;
    }

    private org.eclipse.aether.graph.Dependency convertToAether(Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        org.eclipse.aether.graph.Dependency result = new org.eclipse.aether.graph.Dependency((Artifact)artifact, dependency.getScope(), Boolean.valueOf(dependency.isOptional()), exclusions);
        return result;
    }

    private Exclusion convert(org.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        return this.createLicenseByName(license.getName());
    }

    private ExtensionLicense createLicenseByName(String name) {
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(name);
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(name, null);
    }

    private Artifact resolveVersion(Artifact artifact, List<RemoteRepository> repositories, RepositorySystemSession session) throws VersionResolutionException {
        Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact((Artifact)artifact);
        VersionRequest versionRequest = new VersionRequest(artifact, repositories, "");
        VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
        return pomArtifact.setVersion(versionResult.getVersion());
    }

    private Model loadPom(Artifact artifact, RepositorySystemSession session) throws VersionResolutionException, ArtifactResolutionException, ModelBuildingException {
        List<RemoteRepository> repositories = this.newResolutionRepositories(session);
        Artifact pomArtifact = this.resolveVersion(artifact, repositories, session);
        ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, repositories, "");
        ArtifactResult resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
        pomArtifact = resolveResult.getArtifact();
        return this.createModel(pomArtifact.getFile(), session);
    }

    private Model createModel(File pomFile, RepositorySystemSession session) throws ModelBuildingException {
        List<RemoteRepository> repositories = this.newResolutionRepositories(session, true);
        DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
        modelRequest.setValidationLevel(0);
        modelRequest.setProcessPlugins(false);
        modelRequest.setTwoPhaseBuilding(false);
        modelRequest.setSystemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties()));
        modelRequest.setModelResolver((ModelResolver)new PublicDefaultModelResolver(session, null, "", this.artifactResolver, this.versionRangeResolver, this.remoteRepositoryManager, repositories));
        modelRequest.setPomFile(pomFile);
        return this.modelBuilder.build((ModelBuildingRequest)modelRequest).getEffectiveModel();
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session) {
        return this.newResolutionRepositories(session, false);
    }

    List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, boolean all) {
        List<RemoteRepository> repositories = all ? this.repositoryFactory.getAllMavenRepositories(this.remoteRepository) : Arrays.asList(this.remoteRepository);
        return this.repositorySystem.newResolutionRepositories(session, repositories);
    }

    RemoteRepository newResolutionRepository(RepositorySystemSession session) {
        return this.newResolutionRepositories(session).get(0);
    }
}

