/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.util.Map;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.aether.internal.AetherExtensionFile;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.AetherUtils;
import org.xwiki.extension.repository.internal.MavenExtension;

public class AetherExtension
extends AbstractExtension
implements MavenExtension {
    public static final String PKEY_AETHER_ATIFACT = "aether.Artifact";
    public static final String PKEY_MAVEN_MODEL = "maven.Model";

    public AetherExtension(Artifact artifact, Model mavenModel, AetherExtensionRepository repository) {
        super((ExtensionRepository)repository, AetherUtils.createExtensionId(artifact), artifact.getExtension());
        this.setFile(new AetherExtensionFile(artifact, repository));
        this.putProperty(PKEY_AETHER_ATIFACT, artifact);
        this.putProperty(PKEY_MAVEN_MODEL, mavenModel);
        for (Map.Entry<Object, Object> entry : mavenModel.getProperties().entrySet()) {
            this.putProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public Model getMavenModel() {
        return (Model)this.getProperty(PKEY_MAVEN_MODEL);
    }

    public String getMavenArtifactId() {
        return this.getMavenModel().getArtifactId();
    }

    public String getMavenGroupId() {
        return this.getMavenModel().getGroupId();
    }
}

