/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.repository.AbstractExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.configuration.AetherConfiguration;
import org.xwiki.extension.repository.aether.internal.util.DefaultJavaNetProxySelector;

@Component
@Singleton
@Named(value="maven")
public class AetherExtensionRepositoryFactory
extends AbstractExtensionRepositoryFactory
implements Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<PlexusContainer> plexusProvider;
    @Inject
    private AetherConfiguration aetherConfiguration;
    @Inject
    private ExtensionManagerConfiguration configuration;
    private RepositorySystem repositorySystem;
    private LocalRepository localRepository;

    public void initialize() throws InitializationException {
        try {
            this.repositorySystem = (RepositorySystem)((PlexusContainer)this.plexusProvider.get()).lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to lookup RepositorySystem", (Throwable)e);
        }
        this.localRepository = new LocalRepository(this.aetherConfiguration.getLocalRepository());
    }

    public RepositorySystemSession createRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, this.localRepository));
        session.setConfigProperty("aether.connector.userAgent", (Object)this.configuration.getUserAgent());
        session.setProxySelector((ProxySelector)new DefaultJavaNetProxySelector());
        session.setSystemProperty("version", null);
        session.setSystemProperty("groupId", null);
        ArtifactTypeRegistry artifactTypeRegistry = session.getArtifactTypeRegistry();
        if (artifactTypeRegistry instanceof DefaultArtifactTypeRegistry) {
            DefaultArtifactTypeRegistry defaultArtifactTypeRegistry = (DefaultArtifactTypeRegistry)artifactTypeRegistry;
            defaultArtifactTypeRegistry.add((ArtifactType)new DefaultArtifactType("bundle", "jar", "", "java"));
            defaultArtifactTypeRegistry.add((ArtifactType)new DefaultArtifactType("eclipse-plugin", "jar", "", "java"));
        }
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(false, false));
        return session;
    }

    public ExtensionRepository createRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        try {
            return new AetherExtensionRepository(repositoryDescriptor, this, (PlexusContainer)this.plexusProvider.get(), this.componentManager);
        }
        catch (Exception e) {
            throw new ExtensionRepositoryException("Failed to create repository [" + repositoryDescriptor + "]", (Throwable)e);
        }
    }
}

