/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal.util;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJavaNetProxySelector
implements ProxySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJavaNetProxySelector.class);

    public Proxy getProxy(RemoteRepository repository) {
        try {
            return DefaultJavaNetProxySelector.determineProxy(new URI(repository.getUrl()));
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Invalid repository URL [{}]", (Object)repository.getUrl());
            return null;
        }
    }

    public static Proxy determineProxy(URI targetURI) {
        if (targetURI.getScheme().equals("file")) {
            return null;
        }
        java.net.ProxySelector psel = java.net.ProxySelector.getDefault();
        if (psel == null) {
            return null;
        }
        List<java.net.Proxy> proxies = psel.select(targetURI);
        if (proxies == null || proxies.isEmpty()) {
            return null;
        }
        java.net.Proxy javaProxy = proxies.get(0);
        Proxy result = null;
        if (javaProxy.type() == Proxy.Type.HTTP) {
            if (javaProxy.address() instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)javaProxy.address();
                result = new Proxy(targetURI.getScheme(), isa.getHostName(), isa.getPort(), null);
            } else {
                LOGGER.warn("Unsupported proxy [{}]", (Object)javaProxy);
            }
        }
        return result;
    }
}

