/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.sonatype.aether.impl.VersionRangeResolver;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.aether.internal.AetherExtension;
import org.xwiki.extension.repository.aether.internal.AetherExtensionDependency;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepositoryFactory;
import org.xwiki.extension.repository.aether.internal.AetherUtils;
import org.xwiki.extension.repository.aether.internal.plexus.PlexusComponentManager;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.VersionRangeCollection;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.properties.ConverterManager;

public class AetherExtensionRepository
extends AbstractExtensionRepository {
    public static final String MPKEYPREFIX = "xwiki.extension.";
    public static final String MPNAME_NAME = "name";
    public static final String MPNAME_SUMMARY = "summary";
    public static final String MPNAME_WEBSITE = "website";
    public static final String MPNAME_DESCRIPTION = "description";
    public static final String MPNAME_FEATURES = "features";
    private static final GenericVersionScheme AETHERVERSIONSCHEME = new GenericVersionScheme();
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherExtensionRepository.class);
    private transient PlexusComponentManager plexusComponentManager;
    private transient RemoteRepository remoteRepository;
    private transient ArtifactDescriptorReader mavenDescriptorReader;
    private transient VersionRangeResolver versionRangeResolver;
    private transient ConverterManager converter;
    private transient ExtensionLicenseManager licenseManager;
    private transient AetherExtensionRepositoryFactory repositoryFactory;
    private transient Method loadPomMethod;
    private transient Method convertMethod;

    public AetherExtensionRepository(ExtensionRepositoryDescriptor repositoryDescriptor, AetherExtensionRepositoryFactory repositoryFactory, PlexusComponentManager mavenComponentManager, ComponentManager componentManager) throws Exception {
        super(repositoryDescriptor);
        this.repositoryFactory = repositoryFactory;
        this.plexusComponentManager = mavenComponentManager;
        this.remoteRepository = new RemoteRepository(repositoryDescriptor.getId(), "default", repositoryDescriptor.getURI().toString());
        String user = this.getDescriptor().getProperty("auth.user");
        if (user != null) {
            this.remoteRepository.setAuthentication(new Authentication(user, this.getDescriptor().getProperty("auth.password")));
        }
        try {
            this.remoteRepository.setProxy(this.determineProxy(repositoryDescriptor.getURI()));
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception when trying to find a proxy for [{}]", (Object)repositoryDescriptor.getURI());
        }
        this.converter = (ConverterManager)componentManager.getInstance(ConverterManager.class);
        this.licenseManager = (ExtensionLicenseManager)componentManager.getInstance(ExtensionLicenseManager.class);
        this.versionRangeResolver = (VersionRangeResolver)this.plexusComponentManager.getPlexus().lookup(VersionRangeResolver.class);
        try {
            this.mavenDescriptorReader = (ArtifactDescriptorReader)this.plexusComponentManager.getPlexus().lookup(ArtifactDescriptorReader.class);
            this.loadPomMethod = this.mavenDescriptorReader.getClass().getDeclaredMethod("loadPom", RepositorySystemSession.class, ArtifactDescriptorRequest.class, ArtifactDescriptorResult.class);
            this.loadPomMethod.setAccessible(true);
            this.convertMethod = this.mavenDescriptorReader.getClass().getDeclaredMethod("convert", Dependency.class, ArtifactTypeRegistry.class);
            this.convertMethod.setAccessible(true);
        }
        catch (ComponentLookupException e) {
            // empty catch block
        }
    }

    private Proxy determineProxy(URI targetURI) {
        if (targetURI.getScheme().equals("file")) {
            return null;
        }
        ProxySelector psel = ProxySelector.getDefault();
        if (psel == null) {
            return null;
        }
        List<java.net.Proxy> proxies = psel.select(targetURI);
        if (proxies == null || proxies.isEmpty()) {
            return null;
        }
        java.net.Proxy javaProxy = proxies.get(0);
        Proxy result = null;
        if (javaProxy.type() == Proxy.Type.HTTP) {
            if (javaProxy.address() instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)javaProxy.address();
                result = new Proxy(targetURI.getScheme(), isa.getHostName(), isa.getPort(), null);
            } else {
                LOGGER.warn("Unsupported proxy {}", (Object)javaProxy);
            }
        }
        return result;
    }

    protected RepositorySystemSession createRepositorySystemSession() {
        return this.repositoryFactory.createRepositorySystemSession();
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        if (this.getDescriptor().getType().equals("maven") && this.mavenDescriptorReader != null) {
            return this.resolveMaven(extensionId);
        }
        throw new ResolveException("Unsupported");
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        if (this.getDescriptor().getType().equals("maven") && this.mavenDescriptorReader != null) {
            return this.resolveMaven(extensionDependency);
        }
        throw new ResolveException("Unsupported");
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<org.sonatype.aether.version.Version> versions;
        DefaultArtifact artifact = AetherUtils.createArtifact(id, "(,)");
        try {
            versions = this.resolveVersions((Artifact)artifact, this.createRepositorySystemSession());
            if (versions.isEmpty()) {
                throw new ResolveException("No versions available for id [" + id + "]");
            }
        }
        catch (VersionRangeResolutionException e) {
            throw new ResolveException("Failed to resolve versions for id [" + id + "]", (Throwable)e);
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult(versions.size(), offset, Collections.emptyList());
        }
        int fromId = offset < 0 ? 0 : offset;
        int toId = offset + nb > versions.size() || nb < 0 ? versions.size() : offset + nb;
        ArrayList<DefaultVersion> result = new ArrayList<DefaultVersion>(toId - fromId);
        for (int i = fromId; i < toId; ++i) {
            result.add(new DefaultVersion(versions.get(i).toString()));
        }
        return new CollectionIterableResult(versions.size(), offset, result);
    }

    private org.sonatype.aether.version.Version resolveVersionConstraint(String id, VersionConstraint versionConstraint, RepositorySystemSession session) throws ResolveException {
        if (versionConstraint.getVersion() != null) {
            try {
                return AETHERVERSIONSCHEME.parseVersion(versionConstraint.getVersion().getValue());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new ResolveException("Invalid version [" + versionConstraint.getVersion() + "]", (Throwable)e);
            }
        }
        List commonVersions = null;
        for (VersionRangeCollection range : versionConstraint.getRanges()) {
            ArrayList versions = this.resolveVersionRange(id, (VersionRange)range, session);
            if (commonVersions == null) {
                commonVersions = versionConstraint.getRanges().size() > 1 ? new ArrayList(versions) : versions;
                continue;
            }
            Iterator it = commonVersions.iterator();
            while (it.hasNext()) {
                org.sonatype.aether.version.Version version = (org.sonatype.aether.version.Version)it.next();
                if (versions.contains(version)) continue;
                it.remove();
            }
        }
        if (commonVersions.isEmpty()) {
            throw new ResolveException("No versions available for id [" + id + "] and version constraint [" + versionConstraint + "]");
        }
        return (org.sonatype.aether.version.Version)commonVersions.get(commonVersions.size() - 1);
    }

    private List<org.sonatype.aether.version.Version> resolveVersionRange(String id, VersionRange versionRange, RepositorySystemSession session) throws ResolveException {
        DefaultArtifact artifact = AetherUtils.createArtifact(id, versionRange.getValue());
        try {
            List<org.sonatype.aether.version.Version> versions = this.resolveVersions((Artifact)artifact, session);
            if (versions.isEmpty()) {
                throw new ResolveException("No versions available for id [" + id + "] and version range [" + versionRange + "]");
            }
            return versions;
        }
        catch (VersionRangeResolutionException e) {
            throw new ResolveException("Failed to resolve version range", (Throwable)e);
        }
    }

    private List<org.sonatype.aether.version.Version> resolveVersions(Artifact artifact, RepositorySystemSession session) throws VersionRangeResolutionException {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.addRepository(this.remoteRepository);
        VersionRangeResult rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
        return rangeResult.getVersions();
    }

    private String getProperty(Model model, String propertyName) {
        return model.getProperties().getProperty(MPKEYPREFIX + propertyName);
    }

    private String getPropertyString(Model model, String propertyName, String def) {
        return StringUtils.defaultString((String)this.getProperty(model, propertyName), (String)def);
    }

    private AetherExtension resolveMaven(ExtensionDependency extensionDependency) throws ResolveException {
        String artifactExtension;
        Artifact artifact;
        RepositorySystemSession session = this.createRepositorySystemSession();
        if (extensionDependency instanceof AetherExtensionDependency) {
            artifact = ((AetherExtensionDependency)extensionDependency).getAetherDependency().getArtifact();
            artifactExtension = ((AetherExtensionDependency)extensionDependency).getAetherDependency().getArtifact().getExtension();
        } else {
            artifact = AetherUtils.createArtifact(extensionDependency.getId(), extensionDependency.getVersionConstraint().getValue());
            if (!extensionDependency.getVersionConstraint().getRanges().isEmpty()) {
                artifact = artifact.setVersion(this.resolveVersionConstraint(extensionDependency.getId(), extensionDependency.getVersionConstraint(), session).toString());
            }
            artifactExtension = null;
        }
        return this.resolveMaven(artifact, artifactExtension);
    }

    private AetherExtension resolveMaven(ExtensionId extensionId) throws ResolveException {
        DefaultArtifact artifact = AetherUtils.createArtifact(extensionId.getId(), extensionId.getVersion().getValue());
        return this.resolveMaven((Artifact)artifact, null);
    }

    private AetherExtension resolveMaven(Artifact artifact, String artifactExtension) throws ResolveException {
        Model model;
        RepositorySystemSession session = this.createRepositorySystemSession();
        try {
            model = this.loadPom(artifact, session);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve artifact [" + artifact + "] descriptor", (Throwable)e);
        }
        if (artifactExtension == null) {
            artifactExtension = model.getPackaging().equals("bundle") ? "jar" : model.getPackaging();
        }
        artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifactExtension, artifact.getVersion());
        AetherExtension extension = new AetherExtension(artifact, model, this, this.plexusComponentManager);
        extension.setName(this.getPropertyString(model, MPNAME_NAME, model.getName()));
        extension.setSummary(this.getPropertyString(model, MPNAME_SUMMARY, model.getDescription()));
        extension.setWebsite(this.getPropertyString(model, MPNAME_WEBSITE, model.getUrl()));
        for (Developer developer : model.getDevelopers()) {
            URL authorURL = null;
            if (developer.getUrl() != null) {
                try {
                    authorURL = new URL(developer.getUrl());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            extension.addAuthor((ExtensionAuthor)new DefaultExtensionAuthor((String)StringUtils.defaultIfBlank((CharSequence)developer.getName(), (CharSequence)developer.getId()), authorURL));
        }
        for (License license : model.getLicenses()) {
            extension.addLicense(this.getExtensionLicense(license));
        }
        String featuresString = this.getProperty(model, MPNAME_FEATURES);
        if (StringUtils.isNotBlank((CharSequence)featuresString)) {
            featuresString = featuresString.replaceAll("[\r\n]", "");
            extension.setFeatures((Collection)this.converter.convert(List.class, (Object)featuresString));
        }
        try {
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            for (Dependency mavenDependency : model.getDependencies()) {
                if (mavenDependency.isOptional() || !mavenDependency.getScope().equals("compile") && !mavenDependency.getScope().equals("runtime")) continue;
                extension.addDependency((ExtensionDependency)new AetherExtensionDependency(this.convertToAether(mavenDependency, stereotypes), mavenDependency));
            }
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve dependencies", (Throwable)e);
        }
        return extension;
    }

    private org.sonatype.aether.graph.Dependency convertToAether(Dependency dependency, ArtifactTypeRegistry stereotypes) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (org.sonatype.aether.graph.Dependency)this.convertMethod.invoke((Object)this.mavenDescriptorReader, dependency, stereotypes);
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        return this.createLicenseByName(license.getName());
    }

    private ExtensionLicense createLicenseByName(String name) {
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(name);
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(name, null);
    }

    private Model loadPom(Artifact artifact, RepositorySystemSession session) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArtifactDescriptorRequest artifactDescriptorRequest = new ArtifactDescriptorRequest();
        artifactDescriptorRequest.setArtifact(artifact);
        artifactDescriptorRequest.addRepository(this.remoteRepository);
        ArtifactDescriptorResult artifactDescriptorResult = new ArtifactDescriptorResult(artifactDescriptorRequest);
        return (Model)this.loadPomMethod.invoke((Object)this.mavenDescriptorReader, session, artifactDescriptorRequest, artifactDescriptorResult);
    }

    protected RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }
}

