/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.sonatype.aether.impl.VersionRangeResolver;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.aether.internal.AetherExtension;
import org.xwiki.extension.repository.aether.internal.AetherExtensionDependency;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepositoryFactory;
import org.xwiki.extension.repository.aether.internal.AetherUtils;
import org.xwiki.extension.repository.aether.internal.plexus.PlexusComponentManager;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.VersionRangeCollection;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.properties.ConverterManager;

public class AetherExtensionRepository
extends AbstractExtensionRepository {
    public static final String MPKEYPREFIX = "xwiki.extension.";
    public static final String MPNAME_NAME = "name";
    public static final String MPNAME_SUMMARY = "summary";
    public static final String MPNAME_WEBSITE = "website";
    public static final String MPNAME_DESCRIPTION = "description";
    public static final String MPNAME_FEATURES = "features";
    private static final GenericVersionScheme AETHERVERSIONSCHEME = new GenericVersionScheme();
    private static Method loadPomMethod;
    private static Method convertMethod;
    private transient ComponentManager componentManager;
    private transient PlexusComponentManager plexusComponentManager;
    private transient RemoteRepository remoteRepository;
    private transient ArtifactDescriptorReader mavenDescriptorReader;
    private transient VersionRangeResolver versionRangeResolver;
    private transient ConverterManager converter;
    private transient ExtensionLicenseManager licenseManager;
    private transient AetherExtensionRepositoryFactory repositoryFactory;

    public AetherExtensionRepository(ExtensionRepositoryId repositoryId, AetherExtensionRepositoryFactory repositoryFactory, PlexusComponentManager mavenComponentManager, ComponentManager componentManager) throws Exception {
        super(repositoryId);
        this.repositoryFactory = repositoryFactory;
        this.componentManager = componentManager;
        this.plexusComponentManager = mavenComponentManager;
        this.remoteRepository = new RemoteRepository(repositoryId.getId(), "default", repositoryId.getURI().toString());
        this.converter = (ConverterManager)this.componentManager.getInstance(ConverterManager.class);
        this.licenseManager = (ExtensionLicenseManager)this.componentManager.getInstance(ExtensionLicenseManager.class);
        this.versionRangeResolver = (VersionRangeResolver)this.plexusComponentManager.getPlexus().lookup(VersionRangeResolver.class);
        try {
            this.mavenDescriptorReader = (ArtifactDescriptorReader)this.plexusComponentManager.getPlexus().lookup(ArtifactDescriptorReader.class);
            if (loadPomMethod == null) {
                loadPomMethod = this.mavenDescriptorReader.getClass().getDeclaredMethod("loadPom", RepositorySystemSession.class, ArtifactDescriptorRequest.class, ArtifactDescriptorResult.class);
                loadPomMethod.setAccessible(true);
                convertMethod = this.mavenDescriptorReader.getClass().getDeclaredMethod("convert", Dependency.class, ArtifactTypeRegistry.class);
                convertMethod.setAccessible(true);
            }
        }
        catch (ComponentLookupException e) {
            // empty catch block
        }
    }

    protected RepositorySystemSession createRepositorySystemSession() {
        return this.repositoryFactory.createRepositorySystemSession();
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        return this.resolve((ExtensionDependency)new DefaultExtensionDependency(extensionId.getId(), (VersionConstraint)new DefaultVersionConstraint(null, extensionId.getVersion())));
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        if (this.getId().getType().equals("maven") && this.mavenDescriptorReader != null) {
            return this.resolveMaven(extensionDependency);
        }
        throw new ResolveException("Unsupported");
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<org.sonatype.aether.version.Version> versions;
        DefaultArtifact artifact = AetherUtils.createArtifact(id, "(,)");
        try {
            versions = this.resolveVersions((Artifact)artifact, this.createRepositorySystemSession());
            if (versions.isEmpty()) {
                throw new ResolveException("No versions available for id [" + id + "]");
            }
        }
        catch (VersionRangeResolutionException e) {
            throw new ResolveException("Failed to resolve versions for id [" + id + "]", (Throwable)e);
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult(versions.size(), offset, Collections.emptyList());
        }
        int fromId = offset < 0 ? 0 : offset;
        int toId = offset + nb > versions.size() || nb < 0 ? versions.size() : offset + nb;
        ArrayList<DefaultVersion> result = new ArrayList<DefaultVersion>(toId - fromId);
        for (int i = fromId; i < toId; ++i) {
            result.add(new DefaultVersion(versions.get(i).toString()));
        }
        return new CollectionIterableResult(versions.size(), offset, result);
    }

    private org.sonatype.aether.version.Version resolveVersionConstraint(String id, VersionConstraint versionConstraint, RepositorySystemSession session) throws ResolveException {
        if (versionConstraint.getVersion() != null) {
            try {
                return AETHERVERSIONSCHEME.parseVersion(versionConstraint.getVersion().getValue());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new ResolveException("Invalid version [" + versionConstraint.getVersion() + "]", (Throwable)e);
            }
        }
        List commonVersions = null;
        for (VersionRangeCollection range : versionConstraint.getRanges()) {
            ArrayList versions = this.resolveVersionRange(id, (VersionRange)range, session);
            if (commonVersions == null) {
                commonVersions = versionConstraint.getRanges().size() > 1 ? new ArrayList(versions) : versions;
                continue;
            }
            Iterator it = commonVersions.iterator();
            while (it.hasNext()) {
                org.sonatype.aether.version.Version version = (org.sonatype.aether.version.Version)it.next();
                if (versions.contains(version)) continue;
                it.remove();
            }
        }
        if (commonVersions.isEmpty()) {
            throw new ResolveException("No versions available for id [" + id + "] and version constraint [" + versionConstraint + "]");
        }
        return (org.sonatype.aether.version.Version)commonVersions.get(commonVersions.size() - 1);
    }

    private org.sonatype.aether.version.Version resolveVersion(Artifact artifact, RepositorySystemSession session) throws ResolveException {
        try {
            List<org.sonatype.aether.version.Version> versions = this.resolveVersions(artifact, session);
            if (versions.isEmpty()) {
                throw new ResolveException("No versions available for artifact [" + artifact + "]");
            }
            return versions.get(versions.size() - 1);
        }
        catch (VersionRangeResolutionException e) {
            throw new ResolveException("Failed to resolve version range", (Throwable)e);
        }
    }

    private List<org.sonatype.aether.version.Version> resolveVersionRange(String id, VersionRange versionRange, RepositorySystemSession session) throws ResolveException {
        DefaultArtifact artifact = AetherUtils.createArtifact(id, versionRange.getValue());
        try {
            List<org.sonatype.aether.version.Version> versions = this.resolveVersions((Artifact)artifact, session);
            if (versions.isEmpty()) {
                throw new ResolveException("No versions available for id [" + id + "] and version range [" + versionRange + "]");
            }
            return versions;
        }
        catch (VersionRangeResolutionException e) {
            throw new ResolveException("Failed to resolve version range", (Throwable)e);
        }
    }

    private List<org.sonatype.aether.version.Version> resolveVersions(Artifact artifact, RepositorySystemSession session) throws VersionRangeResolutionException {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.addRepository(this.remoteRepository);
        VersionRangeResult rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
        return rangeResult.getVersions();
    }

    private String getProperty(Model model, String propertyName) {
        return model.getProperties().getProperty(MPKEYPREFIX + propertyName);
    }

    private String getPropertyString(Model model, String propertyName, String def) {
        return StringUtils.defaultString((String)this.getProperty(model, propertyName), (String)def);
    }

    protected AetherExtension resolveMaven(ExtensionDependency extensionDependency) throws ResolveException {
        Model model;
        Artifact artifact;
        RepositorySystemSession session = this.createRepositorySystemSession();
        if (extensionDependency instanceof AetherExtensionDependency) {
            artifact = ((AetherExtensionDependency)extensionDependency).getAetherDependency().getArtifact();
            artifact = artifact.setVersion(this.resolveVersion(artifact, session).toString());
        } else {
            artifact = AetherUtils.createArtifact(extensionDependency.getId(), extensionDependency.getVersionConstraint().getValue());
            artifact = artifact.setVersion(this.resolveVersionConstraint(extensionDependency.getId(), extensionDependency.getVersionConstraint(), session).toString());
        }
        try {
            model = this.loadPom(artifact, session);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve extension [" + extensionDependency + "] descriptor", (Throwable)e);
        }
        String artifactExtension = extensionDependency instanceof AetherExtensionDependency ? ((AetherExtensionDependency)extensionDependency).getAetherDependency().getArtifact().getExtension() : (model.getPackaging().equals("bundle") ? "jar" : model.getPackaging());
        artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifactExtension, artifact.getVersion());
        AetherExtension extension = new AetherExtension(artifact, model, this, this.plexusComponentManager);
        extension.setName(this.getPropertyString(model, MPNAME_NAME, model.getName()));
        extension.setSummary(this.getPropertyString(model, MPNAME_SUMMARY, model.getDescription()));
        extension.setWebsite(this.getPropertyString(model, MPNAME_WEBSITE, model.getUrl()));
        for (Developer developer : model.getDevelopers()) {
            URL authorURL = null;
            if (developer.getUrl() != null) {
                try {
                    authorURL = new URL(developer.getUrl());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            extension.addAuthor((ExtensionAuthor)new DefaultExtensionAuthor((String)StringUtils.defaultIfBlank((CharSequence)developer.getName(), (CharSequence)developer.getId()), authorURL));
        }
        for (License license : model.getLicenses()) {
            extension.addLicense(this.getExtensionLicense(license));
        }
        String featuresString = this.getProperty(model, MPNAME_FEATURES);
        if (StringUtils.isNotBlank((CharSequence)featuresString)) {
            featuresString = featuresString.replaceAll("[\r\n]", "");
            extension.setFeatures((Collection)this.converter.convert(List.class, (Object)featuresString));
        }
        try {
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            for (Dependency mavenDependency : model.getDependencies()) {
                if (mavenDependency.isOptional() || !mavenDependency.getScope().equals("compile") && !mavenDependency.getScope().equals("runtime")) continue;
                extension.addDependency((ExtensionDependency)new AetherExtensionDependency(this.convertToAether(mavenDependency, stereotypes), mavenDependency));
            }
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve dependencies", (Throwable)e);
        }
        return extension;
    }

    private org.sonatype.aether.graph.Dependency convertToAether(Dependency dependency, ArtifactTypeRegistry stereotypes) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (org.sonatype.aether.graph.Dependency)convertMethod.invoke((Object)this.mavenDescriptorReader, dependency, stereotypes);
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        return this.createLicenseByName(license.getName());
    }

    private ExtensionLicense createLicenseByName(String name) {
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(name);
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(name, null);
    }

    private Model loadPom(Artifact artifact, RepositorySystemSession session) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArtifactDescriptorRequest artifactDescriptorRequest = new ArtifactDescriptorRequest();
        artifactDescriptorRequest.setArtifact(artifact);
        artifactDescriptorRequest.addRepository(this.remoteRepository);
        ArtifactDescriptorResult artifactDescriptorResult = new ArtifactDescriptorResult(artifactDescriptorRequest);
        return (Model)loadPomMethod.invoke((Object)this.mavenDescriptorReader, session, artifactDescriptorRequest, artifactDescriptorResult);
    }

    protected RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }
}

