/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.plexus.PlexusComponentManager;

public class AetherExtensionFile
implements ExtensionFile {
    private PlexusComponentManager plexusComponentManager;
    private Artifact artifact;
    private AetherExtensionRepository repository;

    public AetherExtensionFile(Artifact artifact, AetherExtensionRepository repository, PlexusComponentManager plexusComponentManager) {
        this.repository = repository;
        this.plexusComponentManager = plexusComponentManager;
        this.artifact = artifact;
    }

    public long getLength() {
        return -1L;
    }

    public InputStream openStream() throws IOException {
        ArtifactResult artifactResult;
        RepositorySystem repositorySystem;
        try {
            repositorySystem = (RepositorySystem)this.plexusComponentManager.getPlexus().lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw new IOException("Failed to get org.sonatype.aether.RepositorySystem component", e);
        }
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.addRepository(this.repository.getRemoteRepository());
        artifactRequest.setArtifact(this.artifact);
        try {
            RepositorySystemSession session = this.repository.createRepositorySystemSession();
            artifactResult = repositorySystem.resolveArtifact(session, artifactRequest);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException("Failed to resolve artifact", e);
        }
        File aetherFile = artifactResult.getArtifact().getFile();
        return new AetherExtensionFileInputStream(aetherFile);
    }

    static class AetherExtensionFileInputStream
    extends FileInputStream {
        private File file;

        public AetherExtensionFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            FileUtils.deleteQuietly((File)this.file);
        }
    }
}

