/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.repository.AbstractExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.XWikiRepositorySystemSession;

@Component
@Singleton
@Named(value="maven")
public class AetherExtensionRepositoryFactory
extends AbstractExtensionRepositoryFactory
implements Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<PlexusContainer> plexusProvider;
    @Inject
    private ExtensionManagerConfiguration configuration;
    @Inject
    private Environment environment;
    private RepositorySystem repositorySystem;

    public void initialize() throws InitializationException {
        try {
            this.repositorySystem = (RepositorySystem)((PlexusContainer)this.plexusProvider.get()).lookup(RepositorySystem.class);
        }
        catch (org.codehaus.plexus.component.repository.exception.ComponentLookupException e) {
            throw new InitializationException("Failed to lookup RepositorySystem", (Throwable)e);
        }
    }

    public XWikiRepositorySystemSession createRepositorySystemSession() throws IOException, ComponentLookupException {
        XWikiRepositorySystemSession session = (XWikiRepositorySystemSession)this.componentManager.getInstance(XWikiRepositorySystemSession.class);
        session.initialize(this.repositorySystem, this.environment);
        session.setUserAgent(this.configuration.getUserAgent());
        return session;
    }

    public ExtensionRepository createRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        try {
            RemoteRepository.Builder aetherRepositoryBuilder = new RemoteRepository.Builder(repositoryDescriptor.getId(), "default", repositoryDescriptor.getURI().toString());
            String checksumPolicy = repositoryDescriptor.getProperty("checksumPolicy");
            if (StringUtils.isEmpty((CharSequence)checksumPolicy)) {
                checksumPolicy = "warn";
            }
            String updatePolicy = "always";
            aetherRepositoryBuilder.setPolicy(new RepositoryPolicy(true, updatePolicy, checksumPolicy));
            String username = repositoryDescriptor.getProperty("auth.user");
            if (username != null) {
                AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
                authenticationBuilder.addUsername(username);
                authenticationBuilder.addPassword(repositoryDescriptor.getProperty("auth.password"));
                aetherRepositoryBuilder.setAuthentication(authenticationBuilder.build());
            }
            Proxy proxy = XWikiRepositorySystemSession.JREPROXYSELECTOR.getProxy(aetherRepositoryBuilder.build());
            aetherRepositoryBuilder.setProxy(proxy);
            RemoteRepository aetherRepository = aetherRepositoryBuilder.build();
            return new AetherExtensionRepository(repositoryDescriptor, this, aetherRepository, (PlexusContainer)this.plexusProvider.get(), this.componentManager);
        }
        catch (Exception e) {
            throw new ExtensionRepositoryException("Failed to create repository [" + String.valueOf(repositoryDescriptor) + "]", (Throwable)e);
        }
    }

    public File createTemporaryFile(String prefix, String suffix) throws IOException {
        Path filesDirectory = this.environment.getTemporaryDirectory().toPath().resolve("extension/download/files/");
        Files.createDirectories(filesDirectory, new FileAttribute[0]);
        return Files.createTempFile(filesDirectory, prefix, suffix, new FileAttribute[0]).toFile();
    }
}

