/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.maven.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.Extension;
import org.xwiki.extension.maven.internal.MavenExtension;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.maven.internal.converter.AbstractModelConverter;
import org.xwiki.extension.repository.maven.internal.converter.ExtensionTypeConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class ModelConverter
extends AbstractModelConverter<Model> {
    public static final ParameterizedType ROLE = new DefaultParameterizedType(null, Converter.class, new Type[]{Model.class});
    @Inject
    private ExtensionTypeConverter converter;

    public <G> G convert(Type targetType, Object sourceValue) {
        if (targetType == Extension.class) {
            try {
                return (G)this.convertToExtension((Model)sourceValue);
            }
            catch (ComponentLookupException e) {
                throw new ConversionException("Failed to convert the Model", (Throwable)e);
            }
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private MavenExtension convertToExtension(Model model) throws ComponentLookupException {
        String groupId = MavenUtils.resolveGroupId((Model)model);
        String artifactId = model.getArtifactId();
        String type = this.converter.mavenPackagingToExtensionType(model.getPackaging());
        String version = MavenUtils.resolveVersion((Model)model);
        return this.convertToExtension(model, groupId, artifactId, null, type, version);
    }
}

