/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.maven.internal.converter;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.maven.ArtifactExtensionToExtensionType;
import org.xwiki.extension.maven.ArtifactPackagingToExtensionType;
import org.xwiki.extension.maven.ArtifactTypeToExtensionType;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandler;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandlerManager;

@Component(roles={ExtensionTypeConverter.class})
@Singleton
public class ExtensionTypeConverter {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private MavenArtifactHandlerManager handlers;

    public String toExtensionType(MavenArtifactHandler handler) throws ComponentLookupException {
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        String extensionType = handler.getExtension();
        if (componentManager.hasComponent(ArtifactPackagingToExtensionType.class, handler.getPackaging())) {
            extensionType = ((ArtifactPackagingToExtensionType)componentManager.getInstance(ArtifactPackagingToExtensionType.class, handler.getPackaging())).getExtensionType();
        } else if (componentManager.hasComponent(ArtifactTypeToExtensionType.class, handler.getType())) {
            extensionType = ((ArtifactTypeToExtensionType)componentManager.getInstance(ArtifactTypeToExtensionType.class, handler.getType())).getExtensionType();
        } else if (componentManager.hasComponent(ArtifactExtensionToExtensionType.class, handler.getExtension())) {
            extensionType = ((ArtifactExtensionToExtensionType)componentManager.getInstance(ArtifactExtensionToExtensionType.class, handler.getExtension())).getExtensionType();
        }
        return extensionType;
    }

    public String mavenPackagingToExtensionType(String mavenPackaging) throws ComponentLookupException {
        MavenArtifactHandler handler = this.handlers.getByPackaging(mavenPackaging);
        if (handler != null) {
            return this.toExtensionType(handler);
        }
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        String extensionType = mavenPackaging;
        if (componentManager.hasComponent(ArtifactPackagingToExtensionType.class, mavenPackaging)) {
            extensionType = ((ArtifactExtensionToExtensionType)componentManager.getInstance(ArtifactPackagingToExtensionType.class, mavenPackaging)).getExtensionType();
        }
        return extensionType;
    }

    public String mavenTypeToExtensionType(String mavenType) throws ComponentLookupException {
        MavenArtifactHandler handler = this.handlers.getByType(mavenType);
        if (handler != null) {
            return this.toExtensionType(handler);
        }
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        String extensionType = mavenType;
        if (componentManager.hasComponent(ArtifactTypeToExtensionType.class, mavenType)) {
            extensionType = ((ArtifactExtensionToExtensionType)componentManager.getInstance(ArtifactTypeToExtensionType.class, mavenType)).getExtensionType();
        }
        return extensionType;
    }

    public String mavenExtensionToExtensionType(String mavenExtension) throws ComponentLookupException {
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        String extensionType = mavenExtension;
        if (componentManager.hasComponent(ArtifactExtensionToExtensionType.class, mavenExtension)) {
            extensionType = ((ArtifactExtensionToExtensionType)componentManager.getInstance(ArtifactExtensionToExtensionType.class, mavenExtension)).getExtensionType();
        }
        return extensionType;
    }
}

