/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionContext;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionNotFoundException;
import org.xwiki.extension.ExtensionSession;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.maven.internal.DefaultMavenExtensionDependency;
import org.xwiki.extension.maven.internal.MavenExtensionDependency;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.aether.internal.AetherExtension;
import org.xwiki.extension.repository.aether.internal.AetherExtensionDependency;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepositoryFactory;
import org.xwiki.extension.repository.aether.internal.AetherUtils;
import org.xwiki.extension.repository.aether.internal.InvalidExtensionIdException;
import org.xwiki.extension.repository.aether.internal.XWikiRepositorySystemSession;
import org.xwiki.extension.repository.maven.internal.converter.ExtensionTypeConverter;
import org.xwiki.extension.repository.maven.internal.converter.ModelConverter;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandler;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandlerManager;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandlers;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.VersionUtils;
import org.xwiki.properties.converter.Converter;

public class AetherExtensionRepository
extends AbstractExtensionRepository {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AetherExtensionRepository.class);
    protected static final GenericVersionScheme AETHERVERSIONSCHEME = new GenericVersionScheme();
    private static final String ECONTEXT_SESSION = "maven.systeSession";
    protected final PlexusContainer plexusContainer;
    protected final ComponentManager componentManager;
    protected RemoteRepository remoteRepository;
    protected ArtifactDescriptorReader mavenDescriptorReader;
    protected VersionRangeResolver versionRangeResolver;
    protected VersionResolver versionResolver;
    protected ModelBuilder modelBuilder;
    protected ArtifactResolver artifactResolver;
    protected RepositorySystem repositorySystem;
    protected RepositoryConnectorProvider repositoryConnectorProvider;
    protected RemoteRepositoryManager remoteRepositoryManager;
    protected Converter<Model> extensionConverter;
    protected AetherExtensionRepositoryFactory repositoryFactory;
    protected ExtensionFactory factory;
    protected ExtensionContext extensionContext;
    protected MavenArtifactHandlerManager artifactHandlerManager;
    protected ExtensionTypeConverter extensionTypeConverter;
    protected MavenArtifactHandlerManager mavenArtifactHandlerManager;

    public AetherExtensionRepository(ExtensionRepositoryDescriptor repositoryDescriptor, AetherExtensionRepositoryFactory repositoryFactory, RemoteRepository aetherRepository, PlexusContainer plexusContainer, ComponentManager componentManager) throws Exception {
        super(repositoryDescriptor);
        this.remoteRepository = aetherRepository;
        this.repositoryFactory = repositoryFactory;
        this.plexusContainer = plexusContainer;
        this.componentManager = componentManager;
        this.extensionConverter = (Converter)componentManager.getInstance((Type)ModelConverter.ROLE);
        this.factory = (ExtensionFactory)componentManager.getInstance(ExtensionFactory.class);
        this.extensionContext = (ExtensionContext)componentManager.getInstance(ExtensionContext.class);
        this.artifactHandlerManager = (MavenArtifactHandlerManager)componentManager.getInstance(MavenArtifactHandlerManager.class);
        this.extensionTypeConverter = (ExtensionTypeConverter)componentManager.getInstance(ExtensionTypeConverter.class);
        this.mavenArtifactHandlerManager = (MavenArtifactHandlerManager)componentManager.getInstance(MavenArtifactHandlerManager.class);
        this.versionRangeResolver = (VersionRangeResolver)this.plexusContainer.lookup(VersionRangeResolver.class);
        this.versionResolver = (VersionResolver)this.plexusContainer.lookup(VersionResolver.class);
        this.modelBuilder = (ModelBuilder)this.plexusContainer.lookup(ModelBuilder.class);
        this.artifactResolver = (ArtifactResolver)this.plexusContainer.lookup(ArtifactResolver.class);
        this.repositorySystem = (RepositorySystem)this.plexusContainer.lookup(RepositorySystem.class);
        this.mavenDescriptorReader = (ArtifactDescriptorReader)this.plexusContainer.lookup(ArtifactDescriptorReader.class);
        this.repositoryConnectorProvider = (RepositoryConnectorProvider)this.plexusContainer.lookup(RepositoryConnectorProvider.class);
        this.remoteRepositoryManager = (RemoteRepositoryManager)this.plexusContainer.lookup(RemoteRepositoryManager.class);
    }

    public RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public RepositoryConnectorProvider getRepositoryConnectorProvider() {
        return this.repositoryConnectorProvider;
    }

    protected XWikiRepositorySystemSession pushSession() throws ResolveException {
        ExtensionSession extensionSession = this.extensionContext.pushSession();
        XWikiRepositorySystemSession session = (XWikiRepositorySystemSession)extensionSession.get(ECONTEXT_SESSION);
        if (session == null) {
            session = this.createRepositorySystemSession();
            extensionSession.set(ECONTEXT_SESSION, (Object)session);
        }
        return session;
    }

    protected void popSession() {
        this.extensionContext.popSession();
    }

    protected XWikiRepositorySystemSession createRepositorySystemSession() throws ResolveException {
        XWikiRepositorySystemSession session;
        try {
            session = this.repositoryFactory.createRepositorySystemSession();
        }
        catch (Exception e) {
            throw new ResolveException("Failed to create the repository system session", (Throwable)e);
        }
        HashMap<String, String> sessionHttpHeaders = new HashMap<String, String>();
        for (Map.Entry property : this.getDescriptor().getProperties().entrySet()) {
            if (!StringUtils.startsWith((CharSequence)((CharSequence)property.getKey()), (CharSequence)"http.headers.")) continue;
            String headerName = StringUtils.split((String)((String)property.getKey()), (String)".", (int)3)[2];
            sessionHttpHeaders.put(headerName, (String)property.getValue());
        }
        session.addConfigurationProperties(Collections.singletonMap("aether.connector.http.headers", sessionHttpHeaders));
        session.addConfigurationProperties(this.getDescriptor().getProperties());
        return session;
    }

    protected File createTemporaryFile(String prefix, String suffix) throws IOException {
        return this.repositoryFactory.createTemporaryFile(prefix, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream openStream(Artifact artifact) throws IOException {
        File file;
        XWikiRepositorySystemSession session;
        try {
            session = this.pushSession();
        }
        catch (ResolveException e) {
            throw new IOException("Failed to create the repository system session", e);
        }
        try {
            file = this.getFile(artifact, session);
        }
        finally {
            this.popSession();
        }
        return new AetherExtensionFileInputStream(file, true);
    }

    private File getFile(Artifact artifact, XWikiRepositorySystemSession session) throws IOException {
        List<RemoteRepository> repositories = this.newResolutionRepositories((RepositorySystemSession)session, true);
        File file = this.createTemporaryFile(artifact.getArtifactId(), artifact.getExtension());
        ArtifactTransferException exception = null;
        for (RemoteRepository repository : repositories) {
            ArtifactDownload download = new ArtifactDownload();
            download.setArtifact(artifact);
            download.setRepositories(repositories);
            download.setFile(file);
            download.setChecksumPolicy("warn");
            try (RepositoryConnector connector = this.getRepositoryConnectorProvider().newRepositoryConnector((RepositorySystemSession)session, repository);){
                connector.get(Arrays.asList(download), null);
            }
            catch (NoRepositoryConnectorException e) {
                throw new IOException("Failed to download artifact [" + artifact + "]", e);
            }
            if (download.getException() == null) {
                return file;
            }
            if (exception == null) {
                exception = download.getException();
            }
            LOGGER.debug("Failed to download file for artifact [{}] from repository [{}]", new Object[]{artifact, repository, download.getException()});
        }
        throw new IOException("Failed to download file for artifact [" + artifact + "]", (Throwable)exception);
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        try {
            if (this.getDescriptor().getType().equals("maven") && this.mavenDescriptorReader != null) {
                return this.resolveMaven(extensionId);
            }
            throw new ResolveException("Unsupported");
        }
        catch (InvalidExtensionIdException e) {
            throw new ExtensionNotFoundException("Invalid extension id", (Throwable)((Object)e));
        }
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        try {
            if (this.getDescriptor().getType().equals("maven") && this.mavenDescriptorReader != null) {
                return this.resolveMaven(extensionDependency);
            }
            throw new ResolveException("Unsupported");
        }
        catch (InvalidExtensionIdException e) {
            throw new ExtensionNotFoundException("Invalid extension id", (Throwable)((Object)e));
        }
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<org.eclipse.aether.version.Version> versions;
        DefaultArtifact artifact;
        try {
            artifact = AetherUtils.createArtifact(id, "(,)");
        }
        catch (InvalidExtensionIdException e) {
            throw new ExtensionNotFoundException("Invalid extension id", (Throwable)((Object)e));
        }
        XWikiRepositorySystemSession session = this.pushSession();
        try {
            versions = this.resolveVersions((Artifact)artifact, (RepositorySystemSession)session);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve versions for id [" + id + "]", (Throwable)e);
        }
        finally {
            this.popSession();
        }
        if (versions.isEmpty()) {
            throw new ExtensionNotFoundException("No versions available for id [" + id + "]");
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult(versions.size(), offset, Collections.emptyList());
        }
        int fromId = offset < 0 ? 0 : offset;
        int toId = offset + nb > versions.size() || nb < 0 ? versions.size() : offset + nb;
        ArrayList<DefaultVersion> result = new ArrayList<DefaultVersion>(toId - fromId);
        for (int i = fromId; i < toId; ++i) {
            result.add(new DefaultVersion(versions.get(i).toString()));
        }
        return new CollectionIterableResult(versions.size(), offset, result);
    }

    private org.eclipse.aether.version.Version resolveVersionConstraint(String id, VersionConstraint versionConstraint, RepositorySystemSession session) throws ResolveException {
        if (versionConstraint.getVersion() != null) {
            try {
                return AETHERVERSIONSCHEME.parseVersion(versionConstraint.getVersion().getValue());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new ResolveException("Invalid version [" + versionConstraint.getVersion() + "]", (Throwable)e);
            }
        }
        Version strictVersion = VersionUtils.getStrictVersion((Collection)versionConstraint.getRanges());
        if (strictVersion != null) {
            try {
                return AETHERVERSIONSCHEME.parseVersion(strictVersion.getValue());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new ResolveException("Invalid version [" + versionConstraint.getVersion() + "]", (Throwable)e);
            }
        }
        List commonVersions = null;
        for (VersionRange range : versionConstraint.getRanges()) {
            ArrayList versions = this.resolveVersionRange(id, range, session);
            if (commonVersions == null) {
                commonVersions = versionConstraint.getRanges().size() > 1 ? new ArrayList(versions) : versions;
                continue;
            }
            Iterator it = commonVersions.iterator();
            while (it.hasNext()) {
                org.eclipse.aether.version.Version version = (org.eclipse.aether.version.Version)it.next();
                if (versions.contains(version)) continue;
                it.remove();
            }
        }
        if (commonVersions == null || commonVersions.isEmpty()) {
            throw new ExtensionNotFoundException("No versions available for id [" + id + "] and version constraint [" + versionConstraint + "]");
        }
        return (org.eclipse.aether.version.Version)commonVersions.get(commonVersions.size() - 1);
    }

    private List<org.eclipse.aether.version.Version> resolveVersionRange(String id, VersionRange versionRange, RepositorySystemSession session) throws ResolveException {
        List<org.eclipse.aether.version.Version> versions;
        DefaultArtifact artifact = AetherUtils.createArtifact(id, versionRange.getValue());
        try {
            versions = this.resolveVersions((Artifact)artifact, session);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve version range", (Throwable)e);
        }
        if (versions.isEmpty()) {
            throw new ExtensionNotFoundException("No versions available for id [" + id + "] and version range [" + versionRange + "]");
        }
        return versions;
    }

    private org.eclipse.aether.version.Version resolveVersionConstraint(Artifact artifact, RepositorySystemSession session) throws ResolveException {
        try {
            List<org.eclipse.aether.version.Version> versions = this.resolveVersions(artifact, session);
            if (versions.isEmpty()) {
                throw new ExtensionNotFoundException("No versions available for artifact [" + artifact + "]");
            }
            return versions.get(versions.size() - 1);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve version range", (Throwable)e);
        }
    }

    List<org.eclipse.aether.version.Version> resolveVersions(Artifact artifact, RepositorySystemSession session) throws VersionRangeResolutionException {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.newResolutionRepositories(session));
        VersionRangeResult rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
        return rangeResult.getVersions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AetherExtension resolveMaven(ExtensionDependency extensionDependency) throws ResolveException {
        String targetMavenType;
        Artifact artifact;
        XWikiRepositorySystemSession session = this.pushSession();
        try {
            if (extensionDependency instanceof AetherExtensionDependency) {
                artifact = ((AetherExtensionDependency)extensionDependency).getAetherDependency().getArtifact();
                targetMavenType = ((AetherExtensionDependency)extensionDependency).getAetherDependency().getArtifact().getExtension();
                if (!extensionDependency.getVersionConstraint().getRanges().isEmpty()) {
                    artifact = artifact.setVersion(this.resolveVersionConstraint(artifact, (RepositorySystemSession)session).toString());
                }
            } else {
                artifact = AetherUtils.createArtifact(extensionDependency.getId(), extensionDependency.getVersionConstraint().getValue());
                targetMavenType = DefaultMavenExtensionDependency.getType((ExtensionDependency)extensionDependency);
                if (!extensionDependency.getVersionConstraint().getRanges().isEmpty()) {
                    artifact = artifact.setVersion(this.resolveVersionConstraint(extensionDependency.getId(), extensionDependency.getVersionConstraint(), (RepositorySystemSession)session).toString());
                }
            }
        }
        finally {
            this.popSession();
        }
        return this.resolveMaven(artifact, targetMavenType);
    }

    private AetherExtension resolveMaven(ExtensionId extensionId) throws ResolveException {
        DefaultArtifact artifact = AetherUtils.createArtifact(extensionId.getId(), extensionId.getVersion().getValue());
        return this.resolveMaven((Artifact)artifact, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AetherExtension resolveMaven(Artifact artifact, String targetMavenType) throws ResolveException {
        XWikiRepositorySystemSession session = this.pushSession();
        try {
            AetherExtension aetherExtension = this.resolveMaven(artifact, targetMavenType, (RepositorySystemSession)session);
            return aetherExtension;
        }
        finally {
            this.popSession();
        }
    }

    private AetherExtension resolveMaven(Artifact artifact, String targetMavenType, RepositorySystemSession session) throws ResolveException {
        String extensionType;
        Relocation relocation;
        Model model;
        Artifact pomArtifact;
        try {
            pomArtifact = this.downloadPom(artifact, session);
        }
        catch (ArtifactResolutionException e1) {
            if (e1.getResult() != null && !e1.getResult().getExceptions().isEmpty() && e1.getResult().getExceptions().get(0) instanceof ArtifactNotFoundException) {
                throw new ExtensionNotFoundException("Could not find artifact [" + artifact + "] descriptor", (Throwable)e1);
            }
            throw new ResolveException("Failed to resolve artifact [" + artifact + "] descriptor", (Throwable)e1);
        }
        catch (Exception e2) {
            throw new ResolveException("Failed to resolve artifact [" + artifact + "] descriptor", (Throwable)e2);
        }
        try {
            model = this.createModel(pomArtifact.getFile(), session);
        }
        catch (ModelBuildingException e) {
            throw new ResolveException("Failed to create Maven model", (Throwable)e);
        }
        if (model == null) {
            throw new ResolveException("Failed to resolve artifact [" + artifact + "] descriptor");
        }
        DistributionManagement distributionManagement = model.getDistributionManagement();
        if (distributionManagement != null && (relocation = distributionManagement.getRelocation()) != null) {
            return this.resolveMaven((Artifact)new DefaultArtifact(relocation.getGroupId() != null ? relocation.getGroupId() : artifact.getGroupId(), relocation.getArtifactId() != null ? relocation.getArtifactId() : artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), relocation.getVersion() != null ? relocation.getVersion() : artifact.getVersion()), targetMavenType, session);
        }
        MavenArtifactHandler artifactHandler = this.getMavenArtifactHandler(model, session);
        ArtifactType artifactType = this.getArtifactType(targetMavenType, artifactHandler, session);
        String artifactClassifier = artifact.getClassifier();
        if (StringUtils.isEmpty((CharSequence)artifactClassifier)) {
            artifactClassifier = artifactType.getClassifier();
        }
        String artifactExtension = artifactType.getExtension();
        DefaultArtifact fileArtifact = new DefaultArtifact(pomArtifact.getGroupId(), pomArtifact.getArtifactId(), artifact.getClassifier(), artifactExtension, pomArtifact.getVersion());
        boolean includeExtension = false;
        try {
            if (this.isTargetType(targetMavenType, artifactHandler)) {
                extensionType = this.extensionTypeConverter.toExtensionType(artifactHandler);
            } else {
                extensionType = this.extensionTypeConverter.mavenExtensionToExtensionType(artifactExtension);
                includeExtension = true;
            }
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve the extension type", (Throwable)e);
        }
        Extension mavenExtension = (Extension)this.extensionConverter.convert(Extension.class, (Object)model);
        String extensionIdString = MavenUtils.toXWikiExtensionIdentifier((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifactClassifier, null);
        ExtensionId extensionId = new ExtensionId(extensionIdString, this.factory.getVersion(artifact.getBaseVersion()));
        AetherExtension extension = new AetherExtension(extensionId, extensionType, mavenExtension, (Artifact)fileArtifact, this);
        extension.setDependencies(this.toAetherDependencies(mavenExtension.getDependencies(), session));
        extension.setManagedDependencies(this.toAetherDependencies(mavenExtension.getManagedDependencies(), session));
        return extension;
    }

    private boolean isTargetType(String targetMavenType, MavenArtifactHandler artifactHandler) {
        return targetMavenType == null || artifactHandler.getType().equals(targetMavenType) || artifactHandler.getExtension().equals(targetMavenType);
    }

    private MavenArtifactHandler getMavenArtifactHandler(Model model, RepositorySystemSession session) {
        MavenArtifactHandler handler;
        MavenArtifactHandlers handlers = XWikiRepositorySystemSession.getArtifactHandlers(session);
        if (handlers == null) {
            handlers = this.mavenArtifactHandlerManager;
        }
        if ((handler = handlers.getByPackaging(model.getPackaging())) != null) {
            return handler;
        }
        return new MavenArtifactHandler(model.getPackaging(), (ArtifactHandler)new DefaultArtifactHandler(model.getPackaging()));
    }

    private ArtifactType getArtifactType(String targetMavenType, MavenArtifactHandler artifactHandler, RepositorySystemSession session) {
        if (targetMavenType != null) {
            ArtifactType artifactType = session.getArtifactTypeRegistry().get(targetMavenType);
            if (artifactType != null) {
                return artifactType;
            }
            return new DefaultArtifactType(targetMavenType);
        }
        return artifactHandler.getArtifactType();
    }

    private List<ExtensionDependency> toAetherDependencies(Collection<ExtensionDependency> mavenDependencies, RepositorySystemSession session) throws ResolveException {
        ArrayList<ExtensionDependency> dependencies = new ArrayList<ExtensionDependency>(mavenDependencies.size());
        try {
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            for (ExtensionDependency mavenDependency : mavenDependencies) {
                dependencies.add((ExtensionDependency)new AetherExtensionDependency(mavenDependency, this.convertToAether(((MavenExtensionDependency)mavenDependency).getMavenDependency(), stereotypes), this.getDescriptor()));
            }
        }
        catch (Exception e) {
            throw new ResolveException("Failed to resolve dependencies", (Throwable)e);
        }
        return dependencies;
    }

    private Dependency convertToAether(org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        Dependency result = new Dependency((Artifact)artifact, dependency.getScope(), Boolean.valueOf(dependency.isOptional()), exclusions);
        return result;
    }

    private Exclusion convert(org.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private Artifact resolveVersion(Artifact artifact, List<RemoteRepository> repositories, RepositorySystemSession session) throws VersionResolutionException {
        Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact((Artifact)artifact);
        VersionRequest versionRequest = new VersionRequest(artifact, repositories, "");
        VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
        return pomArtifact.setVersion(versionResult.getVersion());
    }

    private Artifact downloadPom(Artifact artifact, RepositorySystemSession session) throws VersionResolutionException, ArtifactResolutionException {
        List<RemoteRepository> repositories = this.newResolutionRepositories(session);
        Artifact pomArtifact = this.resolveVersion(artifact, repositories, session);
        ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, repositories, "");
        ArtifactResult resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
        pomArtifact = resolveResult.getArtifact();
        return pomArtifact;
    }

    private Model createModel(File pomFile, RepositorySystemSession session) throws ModelBuildingException {
        List<RemoteRepository> repositories = this.newResolutionRepositories(session, true);
        DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
        modelRequest.setValidationLevel(0);
        modelRequest.setProcessPlugins(false);
        modelRequest.setTwoPhaseBuilding(false);
        modelRequest.setSystemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties()));
        modelRequest.setModelResolver((ModelResolver)new ProjectModelResolver(session, null, this.repositorySystem, this.remoteRepositoryManager, repositories, ProjectBuildingRequest.RepositoryMerging.POM_DOMINANT, null));
        modelRequest.setPomFile(pomFile);
        modelRequest.setActiveProfileIds(Arrays.asList("legacy"));
        return this.modelBuilder.build((ModelBuildingRequest)modelRequest).getEffectiveModel();
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    protected List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session) {
        return this.newResolutionRepositories(session, false);
    }

    protected List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, boolean all) {
        List<RemoteRepository> repositories = all ? this.getAllMavenRepositories() : Arrays.asList(this.remoteRepository);
        return this.repositorySystem.newResolutionRepositories(session, repositories);
    }

    protected List<RemoteRepository> getAllMavenRepositories() {
        Collection extensionRepositories;
        try {
            extensionRepositories = ((ExtensionRepositoryManager)this.componentManager.getInstance(ExtensionRepositoryManager.class)).getRepositories();
        }
        catch (ComponentLookupException e) {
            return Collections.singletonList(this.remoteRepository);
        }
        ArrayList<RemoteRepository> reposirories = new ArrayList<RemoteRepository>(extensionRepositories.size());
        reposirories.add(this.remoteRepository);
        for (ExtensionRepository extensionRepository : extensionRepositories) {
            RemoteRepository repository;
            if (!(extensionRepository instanceof AetherExtensionRepository) || this.remoteRepository == (repository = ((AetherExtensionRepository)extensionRepository).getRemoteRepository())) continue;
            reposirories.add(repository);
        }
        return reposirories;
    }

    protected RemoteRepository newResolutionRepository(RepositorySystemSession session) {
        return this.newResolutionRepositories(session).get(0);
    }

    protected static class AetherExtensionFileInputStream
    extends FileInputStream {
        private final File file;
        private final boolean delete;

        public AetherExtensionFileInputStream(File file, boolean delete) throws FileNotFoundException {
            super(file);
            this.file = file;
            this.delete = delete;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.delete && this.file.exists()) {
                Files.delete(this.file.toPath());
            }
        }
    }
}

