/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.AbstractForwardingRepositorySystemSession;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.xwiki.environment.Environment;

public class XWikiRepositorySystemSession
extends AbstractForwardingRepositorySystemSession
implements Closeable {
    public static final Map<String, ArtifactType> TYPE_MAPPING = new HashMap<String, ArtifactType>();
    static final JreProxySelector JREPROXYSELECTOR = new JreProxySelector();
    private static final String TYPE_BUNDLE = "bundle";
    private static final String TYPE_ECLIPSE_PLUGIN = "eclipse-plugin";
    private static final String TYPE_WEBJAR = "webjar";
    private final RepositorySystemSession session;
    private final boolean closable;

    public XWikiRepositorySystemSession(RepositorySystemSession session) {
        this.session = session;
        this.closable = false;
        this.addTypes(session);
    }

    public XWikiRepositorySystemSession(RepositorySystem repositorySystem, Environment enviroment) throws IOException {
        DefaultRepositorySystemSession wsession = MavenRepositorySystemUtils.newSession();
        this.session = wsession;
        this.closable = true;
        Path downloadDirectory = XWikiRepositorySystemSession.getDownloadDirectory(enviroment);
        Files.createDirectories(downloadDirectory, new FileAttribute[0]);
        File localDir = Files.createTempDirectory(downloadDirectory, "repository", new FileAttribute[0]).toFile();
        LocalRepository localRepository = new LocalRepository(localDir);
        wsession.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)wsession, localRepository));
        wsession.setProxySelector((ProxySelector)JREPROXYSELECTOR);
        wsession.setSystemProperty("version", null);
        wsession.setSystemProperty("groupId", null);
        this.addTypes((RepositorySystemSession)wsession);
        wsession.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(false, false));
    }

    static Path getDownloadDirectory(Environment enviroment) {
        return enviroment.getTemporaryDirectory().toPath().resolve("extension/download");
    }

    private void addTypes(RepositorySystemSession session) {
        ArtifactTypeRegistry artifactTypeRegistry = session.getArtifactTypeRegistry();
        if (artifactTypeRegistry instanceof DefaultArtifactTypeRegistry) {
            DefaultArtifactTypeRegistry defaultArtifactTypeRegistry = (DefaultArtifactTypeRegistry)artifactTypeRegistry;
            TYPE_MAPPING.forEach((key, value) -> defaultArtifactTypeRegistry.add(value));
        }
    }

    protected RepositorySystemSession getSession() {
        return this.session;
    }

    @Override
    public void close() {
        LocalRepository repository;
        if (this.closable && (repository = this.session.getLocalRepository()).getBasedir().exists()) {
            try {
                FileUtils.deleteDirectory((File)repository.getBasedir());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setUserAgent(String userAgent) {
        if (this.session instanceof DefaultRepositorySystemSession) {
            ((DefaultRepositorySystemSession)this.session).setConfigProperty("aether.connector.userAgent", (Object)userAgent);
        }
    }

    public void addConfigurationProperties(Map<String, ?> properties) {
        if (this.session instanceof DefaultRepositorySystemSession) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                ((DefaultRepositorySystemSession)this.session).setConfigProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        TYPE_MAPPING.put(TYPE_BUNDLE, (ArtifactType)new DefaultArtifactType(TYPE_BUNDLE, "jar", "", "java"));
        TYPE_MAPPING.put(TYPE_ECLIPSE_PLUGIN, (ArtifactType)new DefaultArtifactType(TYPE_ECLIPSE_PLUGIN, "jar", "", "java"));
        TYPE_MAPPING.put(TYPE_WEBJAR, (ArtifactType)new DefaultArtifactType(TYPE_WEBJAR, "jar", "", (String)null));
    }
}

