/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.repository.aether.internal.InvalidExtensionIdException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;

public final class AetherUtils {
    private static final Pattern PARSER_ID = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]+))?");

    public static DefaultArtifact createArtifact(String id, String version) throws ResolveException {
        Matcher matcher = PARSER_ID.matcher(id);
        if (!matcher.matches()) {
            throw new InvalidExtensionIdException("Bad id " + id + ", expected format is <groupId>:<artifactId>[:<classifier>]");
        }
        return new DefaultArtifact(matcher.group(1), matcher.group(2), StringUtils.defaultString((String)matcher.group(4), (String)""), "jar", version);
    }

    public static ExtensionId createExtensionId(Artifact artifact) {
        return AetherUtils.createExtensionId(artifact, null);
    }

    public static ExtensionId createExtensionId(Artifact artifact, ExtensionFactory factory) {
        String extensionId = MavenUtils.toExtensionId((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier());
        return new ExtensionId(extensionId, (Version)(factory != null ? factory.getVersion(artifact.getBaseVersion()) : new DefaultVersion(artifact.getBaseVersion())));
    }
}

