/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.AbstractForwardingRepositorySystemSession;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

public class XWikiRepositorySystemSession
extends AbstractForwardingRepositorySystemSession
implements AutoCloseable {
    static final JreProxySelector JREPROXYSELECTOR = new JreProxySelector();
    private final RepositorySystemSession session;
    private final boolean closable;

    public XWikiRepositorySystemSession(RepositorySystemSession session) {
        this.session = session;
        this.closable = false;
    }

    public XWikiRepositorySystemSession(RepositorySystem repositorySystem) {
        DefaultRepositorySystemSession wsession = MavenRepositorySystemUtils.newSession();
        this.session = wsession;
        this.closable = true;
        File localDir = Files.createTempDir();
        LocalRepository localRepository = new LocalRepository(localDir);
        wsession.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)wsession, localRepository));
        wsession.setProxySelector((ProxySelector)JREPROXYSELECTOR);
        wsession.setSystemProperty("version", null);
        wsession.setSystemProperty("groupId", null);
        ArtifactTypeRegistry artifactTypeRegistry = wsession.getArtifactTypeRegistry();
        if (artifactTypeRegistry instanceof DefaultArtifactTypeRegistry) {
            DefaultArtifactTypeRegistry defaultArtifactTypeRegistry = (DefaultArtifactTypeRegistry)artifactTypeRegistry;
            defaultArtifactTypeRegistry.add((ArtifactType)new DefaultArtifactType("bundle", "jar", "", "java"));
            defaultArtifactTypeRegistry.add((ArtifactType)new DefaultArtifactType("eclipse-plugin", "jar", "", "java"));
        }
        wsession.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(false, false));
    }

    protected RepositorySystemSession getSession() {
        return this.session;
    }

    @Override
    public void close() {
        LocalRepository repository;
        if (this.closable && (repository = this.session.getLocalRepository()).getBasedir().exists()) {
            try {
                FileUtils.deleteDirectory((File)repository.getBasedir());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setUserAgent(String userAgent) {
        if (this.session instanceof DefaultRepositorySystemSession) {
            ((DefaultRepositorySystemSession)this.session).setConfigProperty("aether.connector.userAgent", (Object)userAgent);
        }
    }

    public void addConfigurationProperties(Map<String, String> properties) {
        if (this.session instanceof DefaultRepositorySystemSession) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                ((DefaultRepositorySystemSession)this.session).setConfigProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

