/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.http.internal;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.repository.http.internal.HttpClientFactory;

@Component
@Singleton
public class DefaultHttpClientFactory
implements HttpClientFactory {
    @Inject
    private ExtensionManagerConfiguration configuration;

    @Override
    public HttpClientBuilder createHttpClientBuilder(String user, String password) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        httpClientBuilder.setUserAgent(this.configuration.getUserAgent());
        if (user != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return httpClientBuilder;
    }

    @Override
    public CloseableHttpClient createClient(String user, String password) {
        return this.createHttpClientBuilder(user, password).build();
    }

    @Override
    public HttpClientBuilder createHttpClientBuilder(Map<String, String> properties) {
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder(properties.get("auth.user"), properties.get("auth.password"));
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager();
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        socketConfigBuilder.setSoTimeout(this.getIntProperty(properties, "http.socket.timeout", 30000));
        connectionManager.setSocketConfig(socketConfigBuilder.build());
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(this.getIntProperty(properties, "http.connection.timeout", 30000));
        httpClientBuilder.setDefaultRequestConfig(requestBuilder.build());
        return httpClientBuilder;
    }

    private int getIntProperty(Map<String, String> properties, String key, int def) {
        return NumberUtils.toInt((String)properties.get(key), (int)def);
    }
}

