/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension.maven;

import org.apache.maven.model.Model;

/**
 * Add classifier and type information to Maven {@link Model}.
 * <p>
 * The {@link Model} is designed as an unserialized version of the pom.xml but the same pom can be associated to several
 * different artifacts (with different classifier and type). {@code packaging} is only the default type.
 * 
 * @version $Id: 327241ccbce2330315f4d30c169cd949aff29bf9 $
 * @since 10.9
 * @since 10.8.1
 */
public class ArtifactModel
{
    private String classifier;

    private String type;

    private Model model;

    /**
     * @param model the Maven {@link Model}
     */
    public ArtifactModel(Model model)
    {
        this.model = model;
    }

    /**
     * @return the classifier
     */
    public String getClassifier()
    {
        return this.classifier;
    }

    /**
     * @param classifier the classifier
     */
    public void setClassifier(String classifier)
    {
        this.classifier = classifier;
    }

    /**
     * @return the type
     */
    public String getType()
    {
        return this.type;
    }

    /**
     * @param type the type
     */
    public void setType(String type)
    {
        this.type = type;
    }

    /**
     * @return the Maven {@link Model}
     */
    public Model getModel()
    {
        return this.model;
    }
}
