/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension.maven;

import org.xwiki.component.annotation.Role;

/**
 * Allow an extension to indicate a mapping between a Maven file extension and the corresponding extension type.
 * 
 * @version $Id: 9b77532dfe117553dc747291c3b1213224d90613 $
 * @since 16.4.0RC1
 */
@Role
public interface ArtifactExtensionToExtensionType
{
    /**
     * @return the extension type
     */
    String getExtensionType();
}
