/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.maven.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.maven.internal.DefaultMavenExtensionDependency;
import org.xwiki.extension.maven.internal.MavenCoreExtension;
import org.xwiki.extension.maven.internal.MavenExtension;
import org.xwiki.extension.maven.internal.MavenExtensionDependency;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.repository.internal.core.AbstractExtensionScanner;
import org.xwiki.extension.repository.internal.core.CoreExtensionCache;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;
import org.xwiki.properties.ConverterManager;

@Component
@Named(value="maven")
@Singleton
public class MavenExtensionScanner
extends AbstractExtensionScanner {
    @Inject
    private CoreExtensionCache cache;
    @Inject
    private ConverterManager converter;
    @Inject
    private Environment environment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCoreExtension scanEnvironment(DefaultCoreExtensionRepository repository) {
        InputStream manifestString = this.environment.getResourceAsStream("/META-INF/MANIFEST.MF");
        if (manifestString != null) {
            try {
                Manifest manifest = new Manifest(manifestString);
                Attributes manifestAttributes = manifest.getMainAttributes();
                String extensionId = manifestAttributes.getValue("XWiki-Extension-Id");
                if (extensionId != null) {
                    String[] mavenId = StringUtils.split((String)extensionId, (char)':');
                    String descriptorPath = String.format("/META-INF/maven/%s/%s/pom.xml", mavenId[0], mavenId[1]);
                    URL descriptorURL = this.environment.getResource(descriptorPath);
                    if (descriptorURL != null) {
                        try {
                            DefaultCoreExtension coreExtension;
                            DefaultCoreExtension defaultCoreExtension = coreExtension = this.parseMavenPom(descriptorURL, descriptorURL, repository);
                            return defaultCoreExtension;
                        }
                        catch (Exception e) {
                            this.logger.warn("Failed to parse extension descriptor [{}]", (Object)descriptorURL, (Object)e);
                        }
                    } else {
                        this.logger.warn("Can't find resource file [{}] which contains distribution informations.", (Object)descriptorPath);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to parse environment META-INF/MANIFEST.MF file", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)manifestString);
            }
        }
        return null;
    }

    public void scanJARs(Map<String, DefaultCoreExtension> extensions, Collection<URL> jars, DefaultCoreExtensionRepository repository) {
        Iterator<URL> it = jars.iterator();
        while (it.hasNext()) {
            URL jar = it.next();
            if (!this.scan(extensions, jar, repository)) continue;
            it.remove();
        }
    }

    private boolean scan(Map<String, DefaultCoreExtension> extensions, URL jarURL, DefaultCoreExtensionRepository repository) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setScanners(new Scanner[]{Scanners.Resources});
        configurationBuilder.setUrls(new URL[]{jarURL});
        configurationBuilder.filterInputsBy((Predicate)new FilterBuilder().includePackage("META-INF.maven"));
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set descriptors = reflections.getResources("pom.xml");
        boolean found = false;
        for (String descriptor : descriptors) {
            URL descriptorURL;
            String path = jarURL.toExternalForm();
            try {
                descriptorURL = path.endsWith("/") ? new URL(path + descriptor) : new URL("jar:" + jarURL.toExternalForm() + "!/" + descriptor);
            }
            catch (MalformedURLException e) {
                this.logger.error("Failed to access resource [{}] from jar [{}]", (Object)descriptor, (Object)jarURL);
                continue;
            }
            try {
                DefaultCoreExtension coreExtension = this.getCoreExension(jarURL, descriptorURL, repository);
                this.addCoreExtension(extensions, coreExtension);
                found = true;
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse extension descriptor [{}] ([{}])", new Object[]{descriptorURL, descriptor, e});
            }
        }
        return found;
    }

    private DefaultCoreExtension getCoreExension(URL jarURL, URL descriptorURL, DefaultCoreExtensionRepository repository) throws Exception {
        DefaultCoreExtension coreExtension = this.cache.getExtension(repository, descriptorURL);
        if (coreExtension != null && coreExtension.getDescriptorURL().toString().equals(descriptorURL.toString())) {
            return coreExtension;
        }
        return this.parseMavenPom(jarURL, descriptorURL, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultCoreExtension parseMavenPom(URL jarURL, URL descriptorURL, DefaultCoreExtensionRepository repository) throws Exception {
        InputStream descriptorStream = descriptorURL.openStream();
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model mavenModel = reader.read(descriptorStream);
            MavenUtils.resolveVariables(mavenModel);
            Extension mavenExtension = (Extension)this.converter.convert(Extension.class, (Object)mavenModel);
            MavenCoreExtension coreExtension = new MavenCoreExtension(repository, jarURL, mavenExtension);
            coreExtension.setDescriptorURL(descriptorURL);
            if (mavenModel.getParent() == null) {
                this.cache.store((DefaultCoreExtension)coreExtension);
                coreExtension.setComplete(true);
            }
            MavenCoreExtension mavenCoreExtension = coreExtension;
            return mavenCoreExtension;
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorStream);
        }
    }

    public void guess(Map<String, DefaultCoreExtension> extensions, Collection<URL> jars, DefaultCoreExtensionRepository repository) {
        HashSet<ExtensionDependency> dependencies = new HashSet<ExtensionDependency>();
        for (DefaultCoreExtension coreExtension : extensions.values()) {
            for (ExtensionDependency dependency : coreExtension.getDependencies()) {
                if (extensions.containsKey(dependency.getId())) continue;
                dependencies.add(dependency);
            }
        }
        HashMap<String, Object[]> fileNames = new HashMap<String, Object[]>();
        HashMap<String, Object[]> guessedArtefacts = new HashMap<String, Object[]>();
        for (URL jarURL : jars) {
            try {
                int index;
                String path = jarURL.getPath();
                String filename = path.substring(path.lastIndexOf(47) + 1);
                String type = null;
                int extIndex = filename.lastIndexOf(46);
                if (extIndex != -1) {
                    type = filename.substring(extIndex + 1);
                    filename = filename.substring(0, extIndex);
                }
                if ((index = !filename.endsWith("-SNAPSHOT") ? filename.lastIndexOf(45) : filename.lastIndexOf(45, filename.length() - "-SNAPSHOT".length())) == -1) continue;
                fileNames.put(filename, new Object[]{jarURL});
                String artefactname = filename.substring(0, index);
                String version = filename.substring(index + 1);
                guessedArtefacts.put(artefactname, new Object[]{version, jarURL, type});
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse resource name [{}]", (Object)jarURL, (Object)e);
            }
        }
        try {
            for (DefaultCoreExtension coreExtension : extensions.values()) {
                String artifactId = this.getArtifactId(coreExtension);
                Object[] artefact = (Object[])guessedArtefacts.get(artifactId);
                if (artefact == null) continue;
                if (coreExtension.getId().getVersion().getValue().charAt(0) == '$') {
                    coreExtension.setId(new ExtensionId(coreExtension.getId().getId(), (String)artefact[0]));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension.getType().charAt(0) != '$') continue;
                coreExtension.setType((String)artefact[2]);
                coreExtension.setGuessed(true);
            }
            for (ExtensionDependency extensionDependency : dependencies) {
                Dependency dependency = extensionDependency instanceof MavenExtensionDependency ? ((MavenExtensionDependency)extensionDependency).getMavenDependency() : this.toMavenDependency(extensionDependency.getId(), extensionDependency.getVersionConstraint().getValue(), DefaultMavenExtensionDependency.getType(extensionDependency), DefaultMavenExtensionDependency.getScope(extensionDependency));
                String dependencyId = dependency.getGroupId() + ':' + dependency.getArtifactId();
                DefaultCoreExtension coreExtension = extensions.get(dependencyId);
                if (coreExtension != null) continue;
                String dependencyFileName = dependency.getArtifactId() + '-' + dependency.getVersion();
                if (dependency.getClassifier() != null) {
                    dependencyFileName = dependencyFileName + '-' + dependency.getClassifier();
                    dependencyId = dependencyId + ':' + dependency.getClassifier();
                }
                Object[] filenameArtifact = (Object[])fileNames.get(dependencyFileName);
                Object[] guessedArtefact = (Object[])guessedArtefacts.get(dependency.getArtifactId());
                if (filenameArtifact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)filenameArtifact[0], new ExtensionId(dependencyId, dependency.getVersion()), MavenUtils.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                } else if (guessedArtefact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)guessedArtefact[1], new ExtensionId(dependencyId, (String)guessedArtefact[0]), MavenUtils.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension == null) continue;
                extensions.put(dependencyId, coreExtension);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to guess extra information about some extensions", (Throwable)e);
        }
    }

    private Dependency toMavenDependency(String id, String version, String type, String scope) throws ResolveException {
        Matcher matcher = MavenUtils.PARSER_ID.matcher(id);
        if (!matcher.matches()) {
            throw new ResolveException("Bad id [" + id + "], expected format is <groupId>:<artifactId>[:<classifier>]");
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(matcher.group(1));
        dependency.setArtifactId(matcher.group(2));
        if (matcher.group(4) != null) {
            dependency.setClassifier(StringUtils.defaultString((String)matcher.group(4), (String)""));
        }
        dependency.setVersion(version);
        dependency.setScope(scope);
        if (type != null) {
            dependency.setType(type);
        }
        return dependency;
    }

    private String getArtifactId(DefaultCoreExtension extension) throws ResolveException {
        String artifactId;
        if (extension instanceof MavenExtension) {
            artifactId = ((MavenExtension)extension).getMavenArtifactId();
        } else {
            Matcher matcher = MavenUtils.PARSER_ID.matcher(extension.getId().getId());
            if (!matcher.matches()) {
                throw new ResolveException("Bad id " + extension.getId().getId() + ", expected format is <groupId>:<artifactId>[:<classifier>]");
            }
            artifactId = matcher.group(2);
        }
        return artifactId;
    }
}

