/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.maven.internal.converter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.xwiki.extension.DefaultExtensionPattern;
import org.xwiki.extension.DefaultExtensionScm;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionFeaturesInjector;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionPattern;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.ExtensionScmConnection;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.maven.internal.DefaultMavenExtension;
import org.xwiki.extension.maven.internal.DefaultMavenExtensionDependency;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.properties.converter.AbstractConverter;

public class AbstractModelConverter<T>
extends AbstractConverter<T> {
    private static final String PROP_OPTIONAL_INCLUDED = "optionalIncluded";
    private static final Set<String> XWIKI_GROUPS = new HashSet<String>(Arrays.asList("org.xwiki", "com.xwiki"));
    @Inject
    private ExtensionLicenseManager licenseManager;
    @Inject
    private ExtensionFactory factory;
    @Inject
    private List<ExtensionFeaturesInjector> featureInjectors;

    protected boolean isOptionalIncluded(Properties properties, String groupId) {
        String included = this.getProperty(properties, PROP_OPTIONAL_INCLUDED, true);
        if (included != null) {
            return Boolean.TRUE.toString().equalsIgnoreCase(included);
        }
        for (String prefix : XWIKI_GROUPS) {
            if (!groupId.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected DefaultMavenExtension convertToExtension(Model model, String groupId, String artifactId, String classifier, String type, String versionString) {
        ExtensionDependency extensionDependency;
        ArrayList<ExtensionRepositoryDescriptor> repositories;
        List mavenRepositories;
        String namespacesString;
        IssueManagement issueManagement;
        Version version = this.factory.getVersion(versionString);
        Properties properties = (Properties)model.getProperties().clone();
        DefaultMavenExtension extension = new DefaultMavenExtension(null, groupId, artifactId, classifier, version, type);
        extension.setName(this.getPropertyString(properties, "name", true, model.getName()));
        extension.setSummary(this.getPropertyString(properties, "summary", true, model.getDescription()));
        extension.setWebsite(this.getPropertyString(properties, "website", true, model.getUrl()));
        for (Developer developer : model.getDevelopers()) {
            String authorURL = null;
            if (developer.getUrl() != null) {
                authorURL = developer.getUrl();
            }
            extension.addAuthor(this.factory.getExtensionAuthor((String)StringUtils.defaultIfBlank((CharSequence)developer.getName(), (CharSequence)developer.getId()), authorURL));
        }
        for (License license : model.getLicenses()) {
            extension.addLicense(this.getExtensionLicense(license));
        }
        Scm scm = model.getScm();
        if (scm != null && (scm.getConnection() != null || scm.getDeveloperConnection() != null || scm.getUrl() != null)) {
            ExtensionScmConnection connection = MavenUtils.toExtensionScmConnection(scm.getConnection());
            ExtensionScmConnection developerConnection = MavenUtils.toExtensionScmConnection(scm.getDeveloperConnection());
            extension.setScm((ExtensionScm)new DefaultExtensionScm(scm.getUrl(), connection, developerConnection));
        }
        if ((issueManagement = model.getIssueManagement()) != null && issueManagement.getUrl() != null) {
            extension.setIssueManagement(this.factory.getExtensionIssueManagement(issueManagement.getSystem(), issueManagement.getUrl()));
        }
        ArrayList<ExtensionId> extensionFeatures = new ArrayList<ExtensionId>();
        String featuresString = this.getProperty(properties, "features", true);
        if (StringUtils.isNotBlank((CharSequence)featuresString)) {
            List features = ExtensionUtils.importPropertyStringList((String)featuresString, (boolean)true);
            extensionFeatures.addAll(ExtensionIdConverter.toExtensionIdList((Collection)features, (Version)extension.getId().getVersion()));
        }
        for (ExtensionFeaturesInjector injector : this.featureInjectors) {
            Collection injectedFeatures = injector.getFeatures((Extension)extension);
            if (injectedFeatures == null) continue;
            for (Object injectedFeature : injectedFeatures) {
                if (extensionFeatures.contains(injectedFeature)) continue;
                extensionFeatures.add((ExtensionId)injectedFeature);
            }
        }
        extension.setExtensionFeatures(extensionFeatures);
        String categoryString = this.getProperty(properties, "category", true);
        if (StringUtils.isNotBlank((CharSequence)categoryString)) {
            extension.setCategory(categoryString);
        }
        if (StringUtils.isNotBlank((CharSequence)(namespacesString = this.getProperty(properties, "namespaces", true)))) {
            List namespaces = ExtensionUtils.importPropertyStringList((String)namespacesString, (boolean)true);
            extension.setAllowedNamespaces(namespaces);
        }
        if (!(mavenRepositories = model.getRepositories()).isEmpty()) {
            repositories = new ArrayList<ExtensionRepositoryDescriptor>(mavenRepositories.size());
            for (Repository mavenRepository : mavenRepositories) {
                if (StringUtils.equals((CharSequence)mavenRepository.getId(), (CharSequence)"central")) continue;
                try {
                    ExtensionRepositoryDescriptor extensionRepositoryDescriptor = this.factory.getExtensionRepositoryDescriptor(mavenRepository.getId(), "maven", new URI(mavenRepository.getUrl()), null);
                    repositories.add(extensionRepositoryDescriptor);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        } else {
            repositories = null;
        }
        extension.setRepositories(repositories);
        boolean optionalIncluded = this.isOptionalIncluded(properties, groupId);
        for (Dependency dependency : model.getDependencies()) {
            if (dependency.isOptional() && !optionalIncluded || dependency.getScope() != null && !dependency.getScope().equals("compile") && !dependency.getScope().equals("runtime")) continue;
            extensionDependency = this.toExtensionDependency(dependency, model, repositories);
            extension.addDependency(extensionDependency);
        }
        if (model.getDependencyManagement() != null) {
            for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
                extensionDependency = this.toExtensionDependency(dependency, model, repositories);
                extension.addManagedDependency(extensionDependency);
            }
        }
        extension.putProperty("maven.Model", model);
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("xwiki.extension.")) continue;
            extension.putProperty(key, entry.getValue());
        }
        return extension;
    }

    private ExtensionDependency toExtensionDependency(Dependency mavenDependency, Model model, List<ExtensionRepositoryDescriptor> repositories) {
        String dependencyGroupId = MavenUtils.resolveGroupId(mavenDependency.getGroupId(), model, true);
        String dependencyArtifactId = mavenDependency.getArtifactId();
        String dependencyClassifier = mavenDependency.getClassifier();
        String dependencyVersion = MavenUtils.resolveVersion(mavenDependency.getVersion(), model, true);
        DefaultMavenExtensionDependency dependency = new DefaultMavenExtensionDependency(MavenUtils.toExtensionId(dependencyGroupId, dependencyArtifactId, dependencyClassifier), (VersionConstraint)new DefaultVersionConstraint(dependencyVersion), mavenDependency);
        dependency.setRepositories(repositories);
        for (Exclusion exclusion : mavenDependency.getExclusions()) {
            String exclusionGroupId = exclusion.getGroupId();
            String exclusionArtifactId = exclusion.getArtifactId();
            Pattern idPattern = "*".equals(exclusionGroupId) ? ("*".equals(exclusionArtifactId) ? null : Pattern.compile(MavenUtils.toExtensionId("*", Pattern.quote(exclusionArtifactId), null))) : ("*".equals(exclusionArtifactId) ? Pattern.compile(MavenUtils.toExtensionId(Pattern.quote(exclusionGroupId), "*", null)) : Pattern.compile(MavenUtils.toExtensionId(exclusionGroupId, exclusionArtifactId, null), 16));
            dependency.addExclusion((ExtensionPattern)new DefaultExtensionPattern(idPattern));
        }
        return this.factory.getExtensionDependency((ExtensionDependency)dependency);
    }

    private String getProperty(Properties properties, String propertyName, boolean delete) {
        return delete ? (String)properties.remove("xwiki.extension." + propertyName) : properties.getProperty("xwiki.extension." + propertyName);
    }

    private String getPropertyString(Properties properties, String propertyName, boolean delete, String def) {
        return StringUtils.defaultString((String)this.getProperty(properties, propertyName, delete), (String)def);
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        return this.createLicenseByName(license.getName());
    }

    private ExtensionLicense createLicenseByName(String name) {
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(name);
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(name, null);
    }
}

