/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.maven.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.Extension;
import org.xwiki.extension.maven.internal.MavenExtension;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.maven.internal.converter.AbstractModelConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class ModelConverter
extends AbstractModelConverter<Model> {
    public static final ParameterizedType ROLE = new DefaultParameterizedType(null, Converter.class, new Type[]{Model.class});

    public <G> G convert(Type targetType, Object sourceValue) {
        if (targetType == Extension.class) {
            return (G)this.convertToExtension((Model)sourceValue);
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private MavenExtension convertToExtension(Model model) {
        String groupId = MavenUtils.resolveGroupId(model);
        String artifactId = model.getArtifactId();
        String type = MavenUtils.packagingToType(model.getPackaging());
        String version = MavenUtils.resolveVersion(model);
        return this.convertToExtension(model, groupId, artifactId, null, type, version);
    }
}

