/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.maven.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.Extension;
import org.xwiki.extension.maven.ArtifactModel;
import org.xwiki.extension.maven.internal.MavenExtension;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.maven.internal.converter.AbstractModelConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class ArtifactModelConverter
extends AbstractModelConverter<ArtifactModel> {
    public static final ParameterizedType ROLE = new DefaultParameterizedType(null, Converter.class, new Type[]{ArtifactModel.class});

    public <G> G convert(Type targetType, Object sourceValue) {
        if (targetType == Extension.class) {
            return (G)this.convertToExtension((ArtifactModel)sourceValue);
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private MavenExtension convertToExtension(ArtifactModel artifactModel) {
        String groupId = MavenUtils.resolveGroupId(artifactModel.getModel());
        String artifactId = artifactModel.getModel().getArtifactId();
        String classifier = artifactModel.getClassifier();
        String type = MavenUtils.packagingToType(artifactModel.getType() != null ? artifactModel.getType() : artifactModel.getModel().getPackaging());
        String version = MavenUtils.resolveVersion(artifactModel.getModel());
        return this.convertToExtension(artifactModel.getModel(), groupId, artifactId, classifier, type, version);
    }
}

