/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.maven.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.DefaultExtensionScm;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.ExtensionScmConnection;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.maven.internal.DefaultMavenExtension;
import org.xwiki.extension.maven.internal.DefaultMavenExtensionDependency;
import org.xwiki.extension.maven.internal.MavenExtension;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class ModelConverter
extends AbstractConverter<Model> {
    public static final ParameterizedType ROLE = new DefaultParameterizedType(null, Converter.class, new Type[]{Model.class});
    @Inject
    private ExtensionLicenseManager licenseManager;
    @Inject
    private ExtensionFactory factory;

    public <G> G convert(Type targetType, Object sourceValue) {
        if (targetType == Extension.class) {
            return (G)this.convertToExtension((Model)sourceValue);
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private MavenExtension convertToExtension(Model model) {
        ExtensionDependency extensionDependency;
        ArrayList<ExtensionRepositoryDescriptor> repositories;
        List mavenRepositories;
        String namespacesString;
        String categoryString;
        String featuresString;
        IssueManagement issueManagement;
        Properties properties = (Properties)model.getProperties().clone();
        Version version = this.factory.getVersion(MavenUtils.resolveVersion(model));
        String groupId = MavenUtils.resolveGroupId(model);
        DefaultMavenExtension extension = new DefaultMavenExtension(null, groupId, model.getArtifactId(), version, MavenUtils.packagingToType(model.getPackaging()));
        extension.setName(this.getPropertyString(properties, "name", true, model.getName()));
        extension.setSummary(this.getPropertyString(properties, "summary", true, model.getDescription()));
        extension.setWebsite(this.getPropertyString(properties, "website", true, model.getUrl()));
        for (Developer developer : model.getDevelopers()) {
            String authorURL = null;
            if (developer.getUrl() != null) {
                authorURL = developer.getUrl();
            }
            extension.addAuthor(this.factory.getExtensionAuthor((String)StringUtils.defaultIfBlank((CharSequence)developer.getName(), (CharSequence)developer.getId()), authorURL));
        }
        for (License license : model.getLicenses()) {
            extension.addLicense(this.getExtensionLicense(license));
        }
        Scm scm = model.getScm();
        if (scm != null && (scm.getConnection() != null || scm.getDeveloperConnection() != null || scm.getUrl() != null)) {
            ExtensionScmConnection connection = MavenUtils.toExtensionScmConnection(scm.getConnection());
            ExtensionScmConnection developerConnection = MavenUtils.toExtensionScmConnection(scm.getDeveloperConnection());
            extension.setScm((ExtensionScm)new DefaultExtensionScm(scm.getUrl(), connection, developerConnection));
        }
        if ((issueManagement = model.getIssueManagement()) != null && issueManagement.getUrl() != null) {
            extension.setIssueManagement(this.factory.getExtensionIssueManagement(issueManagement.getSystem(), issueManagement.getUrl()));
        }
        if (StringUtils.isNotBlank((CharSequence)(featuresString = this.getProperty(properties, "features", true)))) {
            List features = ExtensionUtils.importPropertyStringList((String)featuresString, (boolean)true);
            extension.setExtensionFeatures(ExtensionIdConverter.toExtensionIdList((Collection)features, (Version)extension.getId().getVersion()));
        }
        if (StringUtils.isNotBlank((CharSequence)(categoryString = this.getProperty(properties, "category", true)))) {
            extension.setCategory(categoryString);
        }
        if (StringUtils.isNotBlank((CharSequence)(namespacesString = this.getProperty(properties, "namespaces", true)))) {
            List namespaces = ExtensionUtils.importPropertyStringList((String)namespacesString, (boolean)true);
            extension.setAllowedNamespaces(namespaces);
        }
        if (!(mavenRepositories = model.getRepositories()).isEmpty()) {
            repositories = new ArrayList<ExtensionRepositoryDescriptor>(mavenRepositories.size());
            for (Repository repository : mavenRepositories) {
                try {
                    ExtensionRepositoryDescriptor repositoryDescriptor = this.factory.getExtensionRepositoryDescriptor(repository.getId(), "maven", new URI(repository.getUrl()));
                    repositories.add(repositoryDescriptor);
                }
                catch (URISyntaxException repositoryDescriptor) {}
            }
        } else {
            repositories = null;
        }
        extension.setRepositories(repositories);
        for (Dependency dependency : model.getDependencies()) {
            if (dependency.getScope() != null && !dependency.getScope().equals("compile") && !dependency.getScope().equals("runtime")) continue;
            extensionDependency = this.toExtensionDependency(dependency, model, repositories);
            extension.addDependency(extensionDependency);
        }
        if (model.getDependencyManagement() != null) {
            for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
                extensionDependency = this.toExtensionDependency(dependency, model, repositories);
                extension.addManagedDependency(extensionDependency);
            }
        }
        extension.putProperty("maven.Model", model);
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("xwiki.extension.")) continue;
            extension.putProperty(key, entry.getValue());
        }
        return extension;
    }

    private ExtensionDependency toExtensionDependency(Dependency mavenDependency, Model model, List<ExtensionRepositoryDescriptor> repositories) {
        String dependencyGroupId = MavenUtils.resolveGroupId(mavenDependency.getGroupId(), model, true);
        String dependencyArtifactId = mavenDependency.getArtifactId();
        String dependencyClassifier = mavenDependency.getClassifier();
        String dependencyVersion = MavenUtils.resolveVersion(mavenDependency.getVersion(), model, true);
        DefaultMavenExtensionDependency dependency = new DefaultMavenExtensionDependency(MavenUtils.toExtensionId(dependencyGroupId, dependencyArtifactId, dependencyClassifier), (VersionConstraint)new DefaultVersionConstraint(dependencyVersion), mavenDependency);
        dependency.setRepositories(repositories);
        return this.factory.getExtensionDependency((ExtensionDependency)dependency);
    }

    private String getProperty(Properties properties, String propertyName, boolean delete) {
        return delete ? (String)properties.remove("xwiki.extension." + propertyName) : properties.getProperty("xwiki.extension." + propertyName);
    }

    private String getPropertyString(Properties properties, String propertyName, boolean delete, String def) {
        return StringUtils.defaultString((String)this.getProperty(properties, propertyName, delete), (String)def);
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        return this.createLicenseByName(license.getName());
    }

    private ExtensionLicense createLicenseByName(String name) {
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(name);
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(name, null);
    }
}

