/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.maven.internal;

import org.apache.maven.model.Dependency;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.maven.internal.MavenExtensionDependency;
import org.xwiki.extension.version.VersionConstraint;

public class DefaultMavenExtensionDependency
extends DefaultExtensionDependency
implements MavenExtensionDependency {
    public static final String PKEY_MAVEN_DEPENDENCY = "maven.Dependency";
    public static final String PKEY_MAVEN_DEPENDENCY_SCOPE = "maven.dependency.scope";
    public static final String PKEY_MAVEN_DEPENDENCY_OPTIONAL = "maven.dependency.optional";

    public DefaultMavenExtensionDependency(ExtensionDependency dependency) {
        super(dependency);
    }

    public DefaultMavenExtensionDependency(String extensionId, VersionConstraint constraint, Dependency mavenDependency) {
        super(extensionId, constraint, mavenDependency.isOptional());
        this.putProperty(PKEY_MAVEN_DEPENDENCY, mavenDependency);
        this.putProperty(PKEY_MAVEN_DEPENDENCY_SCOPE, mavenDependency.getScope());
    }

    public static String getScope(ExtensionDependency dependency) {
        return (String)dependency.getProperty(PKEY_MAVEN_DEPENDENCY_SCOPE);
    }

    public static boolean isOptional(ExtensionDependency dependency) {
        return (Boolean)dependency.getProperty(PKEY_MAVEN_DEPENDENCY_OPTIONAL, (Object)false);
    }

    @Override
    public Dependency getMavenDependency() {
        return (Dependency)this.getProperty(PKEY_MAVEN_DEPENDENCY);
    }

    @Override
    public String getScope() {
        return DefaultMavenExtensionDependency.getScope(this);
    }

    @Override
    public boolean isOptional() {
        return DefaultMavenExtensionDependency.isOptional(this);
    }
}

