/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.jar.internal.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.classloader.NamespaceURLClassLoader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.ComponentDeclaration;
import org.xwiki.component.internal.StackingComponentEventManager;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.LocalExtensionFile;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.internal.AbstractExtensionHandler;
import org.xwiki.job.Request;
import org.xwiki.observation.ObservationManager;

@Component(hints={"jar", "webjar"})
@Singleton
public class JarExtensionHandler
extends AbstractExtensionHandler
implements Initializable {
    public static final String JAR = "jar";
    public static final String WEBJAR = "webjar";
    public static final String PROPERTY_TYPE = "xwiki.extension.jar.type";
    @Inject
    private ComponentManagerManager componentManagerManager;
    @Inject
    private ClassLoaderManager jarExtensionClassLoader;
    private ComponentAnnotationLoader jarLoader;

    public static boolean isSupported(String type) {
        return type != null && (type.equals(JAR) || type.equals(WEBJAR));
    }

    public static boolean isWebjar(Extension extension) {
        if (extension.getType().equals(WEBJAR)) {
            return true;
        }
        if (extension.getId().getId().startsWith("org.webjars:")) {
            return true;
        }
        return WEBJAR.equals(extension.getProperty(PROPERTY_TYPE));
    }

    public void initialize() throws InitializationException {
        this.jarLoader = new ComponentAnnotationLoader();
    }

    public void initialize(LocalExtension localExtension, String namespace) throws ExtensionException {
        this.install(localExtension, namespace, null);
    }

    private static URL getExtensionURL(LocalExtension localExtension) throws MalformedURLException {
        return new File(localExtension.getFile().getAbsolutePath()).toURI().toURL();
    }

    public void install(LocalExtension localExtension, String namespace, Request request) throws InstallException {
        NamespaceURLClassLoader classLoader = this.jarExtensionClassLoader.getURLClassLoader(namespace, true);
        try {
            classLoader.addURL(JarExtensionHandler.getExtensionURL(localExtension));
        }
        catch (MalformedURLException e) {
            throw new InstallException("Failed to load jar file", (Throwable)e);
        }
        if (this.containsComponents((Extension)localExtension)) {
            this.loadComponents(localExtension.getFile(), classLoader, namespace);
        }
    }

    private boolean containsComponents(Extension extension) {
        return extension != null && extension.getType().equals(JAR) && !JarExtensionHandler.isWebjar(extension);
    }

    public void uninstall(InstalledExtension installedExtension, String namespace, Request request) throws UninstallException {
        NamespaceURLClassLoader classLoader;
        if (installedExtension.isValid(namespace) && (classLoader = this.jarExtensionClassLoader.getURLClassLoader(namespace, false)) != null && (namespace == null || classLoader.getNamespace().equals(namespace))) {
            try {
                this.unloadComponents(installedExtension.getFile(), classLoader, namespace);
            }
            catch (Throwable e) {
                this.logger.warn("Failed to unregister some components of the JAR extension [{}]", (Object)installedExtension.getId(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComponents(LocalExtensionFile jarFile, NamespaceURLClassLoader classLoader, String namespace) throws InstallException {
        try {
            List<ComponentDeclaration> componentDeclarations = this.getDeclaredComponents(jarFile);
            if (componentDeclarations == null) {
                this.logger.debug("[{}] does not contain any components to load", (Object)jarFile.getName());
                return;
            }
            ComponentManager componentManager = this.componentManagerManager.getComponentManager(namespace, true);
            ComponentEventManager componentEventManager = componentManager.getComponentEventManager();
            StackingComponentEventManager stackingComponentEventManager = null;
            try {
                if (componentEventManager instanceof StackingComponentEventManager) {
                    stackingComponentEventManager = (StackingComponentEventManager)componentEventManager;
                } else {
                    stackingComponentEventManager = new StackingComponentEventManager();
                    componentManager.setComponentEventManager((ComponentEventManager)stackingComponentEventManager);
                }
                stackingComponentEventManager.shouldStack(true);
                this.jarLoader.initialize(componentManager, (ClassLoader)classLoader, componentDeclarations);
            }
            finally {
                if (stackingComponentEventManager != null) {
                    if (componentEventManager != stackingComponentEventManager) {
                        componentManager.setComponentEventManager(componentEventManager);
                    }
                    stackingComponentEventManager.setObservationManager((ObservationManager)componentManager.getInstance(ObservationManager.class));
                    stackingComponentEventManager.shouldStack(false);
                    stackingComponentEventManager.flushEvents();
                }
            }
        }
        catch (Exception e) {
            throw new InstallException("Failed to load jar file components", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ComponentDeclaration> getDeclaredComponents(LocalExtensionFile jarFile) throws IOException {
        try (InputStream is = jarFile.openStream();){
            List list = this.jarLoader.getDeclaredComponentsFromJAR(is);
            return list;
        }
    }

    private void unloadComponents(LocalExtensionFile jarFile, NamespaceURLClassLoader classLoader, String namespace) throws IOException {
        List<ComponentDeclaration> componentDeclarations = this.getDeclaredComponents(jarFile);
        if (componentDeclarations == null) {
            this.logger.debug("[{}] does not contain any component", (Object)jarFile.getName());
            return;
        }
        this.jarLoader.unregister(this.componentManagerManager.getComponentManager(namespace, false), (ClassLoader)classLoader, componentDeclarations);
    }
}

