/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.jar.internal.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.jar.internal.handler.JarExtensionHandler;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.event.JobFinishingEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="JarExtensionJobFinishingListener")
public class JarExtensionJobFinishingListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionUninstalledEvent(), new ExtensionUpgradedEvent(), new JobStartedEvent(), new JobFinishingEvent());
    @Inject
    private ClassLoaderManager jarExtensionClassLoader;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    @Named(value="jar")
    private ExtensionHandler jarHandler;
    @Inject
    private Execution execution;
    @Inject
    private Provider<ExtensionInitializer> extensionInitializerProvider;
    @Inject
    private Logger logger;

    public String getName() {
        return "JarExtensionJobFinishedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    private void pushUninstallLevel() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            Stack<UninstalledExtensionCollection> extensions = this.getUninstalledExtensionCollectionStack(true);
            extensions.push(null);
        }
    }

    private void popUninstallLevel() {
        Stack<UninstalledExtensionCollection> extensions;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (extensions = this.getUninstalledExtensionCollectionStack(false)) != null) {
            extensions.pop();
        }
    }

    private Stack<UninstalledExtensionCollection> getUninstalledExtensionCollectionStack(boolean create) {
        ExecutionContext context = this.execution.getContext();
        String contextKey = "extension.jar.uninstalledExtensions";
        if (context != null) {
            Stack extensions = (Stack)context.getProperty("extension.jar.uninstalledExtensions");
            if (extensions == null && create) {
                extensions = new Stack();
                context.setProperty("extension.jar.uninstalledExtensions", extensions);
            }
            return extensions;
        }
        return null;
    }

    private UninstalledExtensionCollection getCurrentJobUninstalledExtensions(boolean create) {
        Stack<UninstalledExtensionCollection> extensions;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (extensions = this.getUninstalledExtensionCollectionStack(false)) != null) {
            UninstalledExtensionCollection collection = extensions.peek();
            if (collection == null && create) {
                collection = new UninstalledExtensionCollection();
                extensions.set(extensions.size() - 1, collection);
            }
            return collection;
        }
        return null;
    }

    private void addUninstalledExtension(String namespace) {
        UninstalledExtensionCollection collection = this.getCurrentJobUninstalledExtensions(true);
        if (collection != null) {
            collection.add(namespace);
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof ExtensionUninstalledEvent) {
            this.onExtensionRemovedEvent((ExtensionEvent)((ExtensionUninstalledEvent)event), (InstalledExtension)source);
        } else if (event instanceof ExtensionUpgradedEvent) {
            for (InstalledExtension previous : (Collection)data) {
                this.onExtensionRemovedEvent((ExtensionEvent)((ExtensionUpgradedEvent)event), previous);
            }
        } else if (event instanceof JobStartedEvent) {
            this.onJobStartedEvent();
        } else {
            this.onJobFinishedEvent();
        }
    }

    private void onExtensionRemovedEvent(ExtensionEvent event, InstalledExtension extension) {
        if (JarExtensionHandler.isSupported(extension.getType())) {
            this.addUninstalledExtension(event.getNamespace());
        }
    }

    private void onJobStartedEvent() {
        this.pushUninstallLevel();
    }

    private void initializeExtensions(String namespace) {
        ExtensionInitializer initializer = (ExtensionInitializer)this.extensionInitializerProvider.get();
        initializer.initialize(namespace, "jar");
        initializer.initialize(namespace, "webjar");
        initializer.initialize(namespace, "webjar-node");
    }

    private void onJobFinishedEvent() {
        UninstalledExtensionCollection collection = this.getCurrentJobUninstalledExtensions(false);
        this.popUninstallLevel();
        if (collection != null) {
            if (collection.rootNamespace) {
                this.unloadJARsFromNamespace(null, null);
                this.jarExtensionClassLoader.dropURLClassLoaders();
                this.initializeExtensions(null);
            } else if (collection.namespaces != null) {
                for (String namespace : collection.namespaces) {
                    this.unloadJARsFromNamespace(namespace, null);
                    this.jarExtensionClassLoader.dropURLClassLoader(namespace);
                    this.initializeExtensions(namespace);
                }
            }
        }
    }

    private void unloadJARsFromNamespace(String namespace, Map<String, Set<InstalledExtension>> unloadedExtensions) {
        Map<String, Set<InstalledExtension>> unloadedExtensionsMap = unloadedExtensions;
        if (unloadedExtensionsMap == null) {
            unloadedExtensionsMap = new HashMap<String, Set<InstalledExtension>>();
        }
        Collection installedExtensions = namespace != null ? this.installedExtensionRepository.getInstalledExtensions(namespace) : this.installedExtensionRepository.getInstalledExtensions();
        for (InstalledExtension installedExtension : installedExtensions) {
            if (!JarExtensionHandler.isSupported(installedExtension.getType()) || namespace != null && installedExtension.isInstalled(null)) continue;
            try {
                this.unloadJAR(installedExtension, namespace, unloadedExtensionsMap);
            }
            catch (Exception e) {
                this.logger.error("Failed to unload installed extension [{}]", (Object)installedExtension, (Object)e);
            }
        }
    }

    private void unloadJAR(InstalledExtension installedExtension, String namespace, Map<String, Set<InstalledExtension>> unloadedExtensions) throws UninstallException {
        Set<InstalledExtension> unloadedExtensionsInNamespace = unloadedExtensions.get(namespace);
        if (unloadedExtensionsInNamespace == null) {
            unloadedExtensionsInNamespace = new HashSet<InstalledExtension>();
            unloadedExtensions.put(namespace, unloadedExtensionsInNamespace);
        }
        if (unloadedExtensionsInNamespace.contains(installedExtension)) {
            return;
        }
        if (namespace == null) {
            if (installedExtension.isInstalled(null)) {
                try {
                    Map bDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId());
                    for (Map.Entry entry : bDependencies.entrySet()) {
                        for (InstalledExtension bDependency : (Collection)entry.getValue()) {
                            this.unloadJAR(bDependency, (String)entry.getKey(), unloadedExtensions);
                        }
                    }
                }
                catch (ResolveException e) {
                    this.logger.error("Failed to get backward dependencies for installed extension [{}]", (Object)installedExtension, (Object)e);
                }
                this.jarHandler.uninstall(installedExtension, null, null);
                unloadedExtensionsInNamespace.add(installedExtension);
            } else {
                for (String namespace2 : installedExtension.getNamespaces()) {
                    this.unloadJAR(installedExtension, namespace2, unloadedExtensions);
                }
            }
        } else {
            this.unloadJARFromNamespace(installedExtension, namespace, unloadedExtensions, unloadedExtensionsInNamespace);
        }
    }

    private void unloadJARFromNamespace(InstalledExtension installedExtension, String namespace, Map<String, Set<InstalledExtension>> unloadedExtensions, Set<InstalledExtension> unloadedExtensionsInNamespace) throws UninstallException {
        try {
            Collection bDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace);
            for (InstalledExtension bDependency : bDependencies) {
                this.unloadJAR(bDependency, namespace, unloadedExtensions);
            }
        }
        catch (ResolveException e) {
            this.logger.error("Failed to get backward dependencies for installed extension [{}] on namespace [{}]", new Object[]{installedExtension, namespace, e});
        }
        this.jarHandler.uninstall(installedExtension, namespace, null);
        unloadedExtensionsInNamespace.add(installedExtension);
    }

    private static final class UninstalledExtensionCollection {
        private boolean rootNamespace;
        private Set<String> namespaces;

        private UninstalledExtensionCollection() {
        }

        private void add(String namespace) {
            if (!this.rootNamespace) {
                if (namespace != null) {
                    if (this.namespaces == null) {
                        this.namespaces = new HashSet<String>();
                    }
                    this.namespaces.add(namespace);
                } else {
                    this.rootNamespace = true;
                }
            }
        }
    }
}

