/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.version.VersionConstraint;

public abstract class AbstractExtensionDependency
implements ExtensionDependency {
    protected String id;
    protected VersionConstraint versionConstraint;
    protected List<ExtensionRepositoryDescriptor> repositories;
    protected boolean optional;
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public AbstractExtensionDependency(ExtensionDependency dependency) {
        this(dependency, null);
    }

    public AbstractExtensionDependency(ExtensionDependency dependency, VersionConstraint versionConstraint) {
        this(dependency.getId(), versionConstraint != null ? versionConstraint : dependency.getVersionConstraint(), dependency.isOptional(), dependency.getProperties());
        this.setRepositories(dependency.getRepositories());
    }

    public AbstractExtensionDependency(String id, VersionConstraint versionConstraint) {
        this(id, versionConstraint, false);
    }

    public AbstractExtensionDependency(String id, VersionConstraint versionConstraint, boolean optional) {
        this(id, versionConstraint, optional, null);
    }

    public AbstractExtensionDependency(String id, VersionConstraint versionConstraint, Map<String, Object> properties) {
        this.id = id;
        this.versionConstraint = versionConstraint;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public AbstractExtensionDependency(String id, VersionConstraint versionConstraint, boolean optional, Map<String, Object> properties) {
        this.id = id;
        this.versionConstraint = versionConstraint;
        this.optional = optional;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    @Override
    public Collection<ExtensionRepositoryDescriptor> getRepositories() {
        return this.repositories != null ? this.repositories : Collections.emptyList();
    }

    public void setRepositories(Collection<? extends ExtensionRepositoryDescriptor> repositories) {
        this.repositories = repositories != null ? Collections.unmodifiableList(new ArrayList<ExtensionRepositoryDescriptor>(repositories)) : null;
    }

    public void addRepository(ExtensionRepositoryDescriptor repository) {
        ArrayList<ExtensionRepositoryDescriptor> newrepositories = new ArrayList<ExtensionRepositoryDescriptor>(this.getRepositories());
        newrepositories.add(repository);
        this.repositories = Collections.unmodifiableList(newrepositories);
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isCompatible(Extension extension) {
        if (this.isCompatible(extension.getId())) {
            return true;
        }
        for (ExtensionId extensionId : extension.getExtensionFeatures()) {
            if (!this.isCompatible(extensionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatible(ExtensionId extensionId) {
        return this.getId().equals(extensionId.getId()) && this.getVersionConstraint().isCompatible(extensionId.getVersion());
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public <T> T getProperty(String key, T def) {
        return (T)(this.properties.containsKey(key) ? this.properties.get(key) : def);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getId());
        if (this.getVersionConstraint() != null) {
            str.append('-');
            str.append(this.getVersionConstraint());
        }
        return str.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getId());
        builder.append((Object)this.getVersionConstraint());
        builder.append(this.isOptional());
        builder.append(this.getRepositories());
        builder.append(this.getProperties());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtensionDependency) {
            ExtensionDependency otherDependency = (ExtensionDependency)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getId(), (Object)otherDependency.getId());
            builder.append((Object)this.getVersionConstraint(), (Object)otherDependency.getVersionConstraint());
            builder.append(this.isOptional(), otherDependency.isOptional());
            builder.append(this.getRepositories(), otherDependency.getRepositories());
            builder.append(this.getProperties(), otherDependency.getProperties());
            equals = builder.isEquals();
        } else {
            equals = false;
        }
        return equals;
    }
}

