/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.DefaultExtensionIssueManagement;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.internal.SoftCache;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;

@Component(roles={ExtensionFactory.class})
@Singleton
public class ExtensionFactory {
    private SoftCache<ExtensionDependency, ExtensionDependency> dependencies = new SoftCache();
    private SoftCache<ExtensionAuthor, ExtensionAuthor> authors = new SoftCache();
    private SoftCache<ExtensionRepositoryDescriptor, ExtensionRepositoryDescriptor> repositories = new SoftCache();
    private SoftCache<ExtensionIssueManagement, ExtensionIssueManagement> issueManagements = new SoftCache();
    private SoftCache<String, Version> versions = new SoftCache();
    private SoftCache<String, VersionConstraint> versionConstrains = new SoftCache();

    public ExtensionDependency getExtensionDependency(ExtensionDependency dependency) {
        return this.dependencies.get(dependency, dependency);
    }

    public ExtensionDependency getExtensionDependency(String id, VersionConstraint versionConstraint, boolean optional, Map<String, Object> properties) {
        return this.getExtensionDependency(new DefaultExtensionDependency(id, versionConstraint, optional, properties));
    }

    public ExtensionAuthor getExtensionAuthor(ExtensionAuthor author) {
        return this.authors.get(author, author);
    }

    public ExtensionAuthor getExtensionAuthor(String name, String url) {
        return this.getExtensionAuthor(new DefaultExtensionAuthor(name, url));
    }

    public ExtensionRepositoryDescriptor getExtensionRepositoryDescriptor(ExtensionRepositoryDescriptor repository) {
        return this.repositories.get(repository, repository);
    }

    public ExtensionRepositoryDescriptor getExtensionRepositoryDescriptor(String id, String type, URI uri) {
        return this.getExtensionRepositoryDescriptor(new DefaultExtensionRepositoryDescriptor(id, type, uri));
    }

    public ExtensionIssueManagement getExtensionIssueManagement(ExtensionIssueManagement issueManagement) {
        return this.issueManagements.get(issueManagement, issueManagement);
    }

    public ExtensionIssueManagement getExtensionIssueManagement(String system, String url) {
        return this.getExtensionIssueManagement(new DefaultExtensionIssueManagement(system, url));
    }

    public Version getVersion(Version version) {
        return this.versions.get(version.getValue(), version);
    }

    public Version getVersion(String rawVersion) {
        Version version = this.versions.get(rawVersion);
        if (version == null) {
            version = new DefaultVersion(rawVersion);
            this.versions.put(rawVersion, version);
        }
        return version;
    }

    public VersionConstraint getVersionConstraint(VersionConstraint versionConstraint) {
        return this.versionConstrains.get(versionConstraint.getValue(), versionConstraint);
    }

    public VersionConstraint getVersionConstraint(String rawConstraint) {
        VersionConstraint constraint = this.versionConstrains.get(rawConstraint);
        if (constraint == null) {
            constraint = new DefaultVersionConstraint(rawConstraint);
            this.versionConstrains.put(rawConstraint, constraint);
        }
        return constraint;
    }
}

