/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.logging.marker.TranslationMarker;

@Component
@Named(value="install")
public class InstallJob
extends AbstractExtensionJob<InstallRequest, DefaultJobStatus<InstallRequest>> {
    public static final String JOBTYPE = "install";
    private static final TranslationMarker LOG_DOWNLOADING = new TranslationMarker("extension.log.job.downloading");
    @Inject
    @Named(value="installplan")
    private Job installPlanJob;
    @Inject
    private Execution execution;

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        this.progressManager.pushLevelProgress(3, (Object)this);
        ExecutionContext context = this.execution.getContext();
        try {
            this.progressManager.startStep((Object)this);
            InstallRequest planRequest = new InstallRequest(this.getRequest());
            planRequest.setId(null);
            this.installPlanJob.initialize((Request)planRequest);
            this.installPlanJob.run();
            ExtensionPlan plan = (ExtensionPlan)this.installPlanJob.getStatus();
            if (plan.getError() != null) {
                throw new InstallException("Failed to create install plan", plan.getError());
            }
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            context.setProperty("job.extension.plan", (Object)plan);
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.progressManager.pushLevelProgress(actions.size(), actions);
            try {
                for (ExtensionPlanAction action : actions) {
                    this.progressManager.startStep(actions);
                    this.store(action);
                    this.progressManager.endStep(actions);
                }
            }
            finally {
                this.progressManager.popLevelProgress(actions);
            }
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            this.applyActions(actions);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
            context.removeProperty("job.extension.plan");
        }
    }

    private void store(ExtensionPlanAction action) throws LocalExtensionRepositoryException {
        if (action.getAction() == ExtensionPlanAction.Action.INSTALL || action.getAction() == ExtensionPlanAction.Action.UPGRADE || action.getAction() == ExtensionPlanAction.Action.DOWNGRADE) {
            this.storeExtension(action.getExtension());
        }
    }

    private void storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        if (!this.localExtensionRepository.exists(extension.getId())) {
            if (((InstallRequest)this.getRequest()).isVerbose()) {
                this.logger.info((Marker)LOG_DOWNLOADING, "Downloading extension [{}]", (Object)extension.getId());
            }
            this.localExtensionRepository.storeExtension(extension);
        }
    }
}

