/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.DefaultExtensionIssueManagement;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;

@Component(roles={ExtensionFactory.class})
@Singleton
public class ExtensionFactory {
    private WeakHashMap<ExtensionDependency, ExtensionDependency> dependencies = new WeakHashMap();
    private WeakHashMap<ExtensionAuthor, ExtensionAuthor> authors = new WeakHashMap();
    private WeakHashMap<ExtensionRepositoryDescriptor, ExtensionRepositoryDescriptor> repositories = new WeakHashMap();
    private WeakHashMap<ExtensionIssueManagement, ExtensionIssueManagement> issueManagements = new WeakHashMap();
    private WeakHashMap<String, Version> versions = new WeakHashMap();
    private WeakHashMap<String, VersionConstraint> versionConstrains = new WeakHashMap();

    private static <T> T get(WeakHashMap<T, T> map, T entry) {
        T sharedEntry = map.get(entry);
        if (sharedEntry == null) {
            sharedEntry = entry;
        }
        map.put(sharedEntry, sharedEntry);
        return sharedEntry;
    }

    private static <K, V> V get(WeakHashMap<K, V> map, K key, V value) {
        V sharedValue = map.get(key);
        if (sharedValue == null) {
            sharedValue = value;
        }
        map.put(key, sharedValue);
        return sharedValue;
    }

    public ExtensionDependency getExtensionDependency(ExtensionDependency dependency) {
        return ExtensionFactory.get(this.dependencies, dependency);
    }

    public ExtensionDependency getExtensionDependency(String id, VersionConstraint versionConstraint, Map<String, Object> properties) {
        return this.getExtensionDependency(new DefaultExtensionDependency(id, versionConstraint, properties));
    }

    public ExtensionAuthor getExtensionAuthor(ExtensionAuthor author) {
        return ExtensionFactory.get(this.authors, author);
    }

    public ExtensionAuthor getExtensionAuthor(String name, URL url) {
        return this.getExtensionAuthor(new DefaultExtensionAuthor(name, url));
    }

    public ExtensionRepositoryDescriptor getExtensionRepositoryDescriptor(ExtensionRepositoryDescriptor repository) {
        return ExtensionFactory.get(this.repositories, repository);
    }

    public ExtensionRepositoryDescriptor getExtensionRepositoryDescriptor(String id, String type, URI uri) {
        return this.getExtensionRepositoryDescriptor(new DefaultExtensionRepositoryDescriptor(id, type, uri));
    }

    public ExtensionIssueManagement getExtensionIssueManagement(ExtensionIssueManagement issueManagement) {
        return ExtensionFactory.get(this.issueManagements, issueManagement);
    }

    public ExtensionIssueManagement getExtensionIssueManagement(String system, String url) {
        return this.getExtensionIssueManagement(new DefaultExtensionIssueManagement(system, url));
    }

    public Version getVersion(Version version) {
        return ExtensionFactory.get(this.versions, version.getValue(), version);
    }

    public Version getVersion(String rawVersion) {
        return this.getVersion(new DefaultVersion(rawVersion));
    }

    public VersionConstraint getVersionConstraint(VersionConstraint versionConstraint) {
        return ExtensionFactory.get(this.versionConstrains, versionConstraint.getValue(), versionConstraint);
    }

    public VersionConstraint getVersionConstraint(String rawConstraint) {
        return this.getVersionConstraint(new DefaultVersionConstraint(rawConstraint));
    }
}

