/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public final class PathUtils {
    private static final String JAR_PREFIX = "jar:";
    private static final String JAR_SEPARATOR = "!/";

    private PathUtils() {
    }

    public static String encode(String str) {
        String encoded;
        try {
            encoded = URLEncoder.encode(str, "UTF-8").replace(".", "%2E").replace("*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            encoded = str;
        }
        return encoded;
    }

    public static URL getExtensionURL(URL descriptorURL, String pattern) throws MalformedURLException {
        String extensionURLStr = descriptorURL.toString();
        if (pattern != null) {
            extensionURLStr = extensionURLStr.substring(0, descriptorURL.toString().indexOf(pattern));
        }
        if (extensionURLStr.startsWith(JAR_PREFIX)) {
            int start = JAR_PREFIX.length();
            int end = extensionURLStr.length();
            if (extensionURLStr.endsWith(JAR_SEPARATOR)) {
                end -= JAR_SEPARATOR.length();
            }
            extensionURLStr = extensionURLStr.substring(start, end);
        }
        return new URL(extensionURLStr);
    }

    public static URL getExtensionURL(URL descriptorURL) throws IOException {
        URLConnection connection = descriptorURL.openConnection();
        if (connection instanceof JarURLConnection) {
            return ((JarURLConnection)connection).getJarFileURL();
        }
        return descriptorURL;
    }
}

