/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;

@Component
@Named(value="uninstall")
public class UninstallJob
extends AbstractExtensionJob<UninstallRequest, DefaultJobStatus<UninstallRequest>> {
    public static final String JOBTYPE = "uninstall";
    @Inject
    @Named(value="uninstallplan")
    private Job uninstallPlanJob;
    @Inject
    private Execution execution;

    public String getType() {
        return JOBTYPE;
    }

    protected UninstallRequest castRequest(Request request) {
        UninstallRequest uninstallRequest = request instanceof UninstallRequest ? (UninstallRequest)request : new UninstallRequest(request);
        return uninstallRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        this.progressManager.pushLevelProgress(2, (Object)this);
        ExecutionContext context = this.execution.getContext();
        try {
            this.progressManager.startStep((Object)this);
            UninstallRequest planRequest = new UninstallRequest(this.getRequest());
            planRequest.setId(null);
            this.uninstallPlanJob.initialize((Request)planRequest);
            this.uninstallPlanJob.run();
            ExtensionPlan plan = (ExtensionPlan)this.uninstallPlanJob.getStatus();
            List log = plan.getLog().getLogs(LogLevel.ERROR);
            if (!log.isEmpty()) {
                throw new UninstallException("Failed to create install plan: " + ((LogEvent)log.get(0)).getFormattedMessage(), ((LogEvent)log.get(0)).getThrowable());
            }
            this.progressManager.startStep((Object)this);
            context.setProperty("job.extension.plan", (Object)plan);
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.applyActions(actions);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
            context.removeProperty("job.extension.plan");
        }
    }
}

