/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.maven;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.xwiki.extension.DefaultExtensionScmConnection;
import org.xwiki.extension.ExtensionScmConnection;

public class MavenUtils {
    public static final String MPKEYPREFIX = "xwiki.extension.";
    public static final String MPNAME_NAME = "name";
    public static final String MPNAME_SUMMARY = "summary";
    public static final String MPNAME_WEBSITE = "website";
    public static final String MPNAME_FEATURES = "features";
    public static final String MPNAME_CATEGORY = "category";
    public static final String MPNAME_NAMESPACES = "namespaces";
    public static final String PKEY_MAVEN_MODEL = "maven.Model";
    public static final String JAR_EXTENSION = "jar";
    public static final String JAVA_LANGUAGE = "java";
    public static final String MAVENPACKAGE = "META-INF.maven";
    public static final String SNAPSHOTSUFFIX = "-SNAPSHOT";
    public static final Pattern PARSER_ID = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]+))?");
    public static final String MF_EXTENSION_ID = "XWiki-Extension-Id";
    public static final String UNKNOWN = "unknown";

    public static ExtensionScmConnection toExtensionScmConnection(String connectionURL) {
        if (connectionURL == null) {
            return null;
        }
        String path = connectionURL;
        if (path.startsWith("scm:")) {
            path = path.substring("scm:".length());
        }
        String system = "git";
        int index = path.indexOf(58);
        if (index >= 0) {
            if (index != 0) {
                system = path.substring(0, index);
            }
            path = path.substring(index + 1);
        }
        return new DefaultExtensionScmConnection(system, path);
    }

    public static String toExtensionId(String groupId, String artifactId, String classifier) {
        StringBuilder builder = new StringBuilder();
        builder.append(groupId);
        builder.append(':');
        builder.append(artifactId);
        if (StringUtils.isNotEmpty((CharSequence)classifier)) {
            builder.append(':');
            builder.append(classifier);
        }
        return builder.toString();
    }

    public static String packagingToType(String packaging) {
        if (packaging.equals("bundle")) {
            return JAR_EXTENSION;
        }
        return packaging;
    }

    public static String resolveVersion(Model mavenModel) {
        return MavenUtils.resolveVersion(mavenModel.getVersion(), mavenModel, false);
    }

    public static String resolveVersion(String modelVersion, Model mavenModel, boolean dependency) {
        String version = modelVersion;
        if (version == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                version = parent.getVersion();
            }
        } else if (version.startsWith("$")) {
            String propertyName = version.substring(2, version.length() - 1);
            if (propertyName.equals("project.version") || propertyName.equals("pom.version") || propertyName.equals("version")) {
                version = MavenUtils.resolveVersion(mavenModel.getVersion(), mavenModel, false);
            } else {
                String value = mavenModel.getProperties().getProperty(propertyName);
                if (value != null) {
                    version = value;
                }
            }
        }
        if (version == null) {
            version = UNKNOWN;
        }
        return version;
    }

    public static String resolveGroupId(Model mavenModel) {
        return MavenUtils.resolveGroupId(mavenModel.getGroupId(), mavenModel, false);
    }

    public static String resolveGroupId(String modelGroupId, Model mavenModel, boolean dependency) {
        String groupId = modelGroupId;
        if (groupId == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                groupId = parent.getGroupId();
            }
        } else if (groupId.startsWith("$")) {
            String propertyName = groupId.substring(2, groupId.length() - 1);
            String value = mavenModel.getProperties().getProperty(propertyName);
            if (value != null) {
                groupId = value;
            }
        }
        if (groupId == null) {
            groupId = UNKNOWN;
        }
        return groupId;
    }

    public static void resolveVariables(Model model) {
        model.setVersion(MavenUtils.resolveVersion(model));
        model.setGroupId(MavenUtils.resolveGroupId(model));
        for (Map.Entry<Object, Object> entry : model.getProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String value = (String)entry.getValue();
            entry.setValue(value.replace("${project.version}", model.getVersion()));
        }
    }
}

