/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;

public class ExtensionId
implements Serializable,
Comparable<ExtensionId> {
    public static final ParameterizedType TYPE_LIST = new DefaultParameterizedType(null, List.class, new Type[]{ExtensionId.class});
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Version version;

    public ExtensionId(String id) {
        this(id, (Version)null);
    }

    public ExtensionId(String id, String version) {
        this(id, new DefaultVersion(version));
    }

    public ExtensionId(String id, Version version) {
        this.id = id;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtensionId) {
            ExtensionId extensionId = (ExtensionId)obj;
            return Objects.equal((Object)extensionId.getId(), (Object)this.getId()) && Objects.equal((Object)extensionId.getVersion(), (Object)this.getVersion());
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getId());
        builder.append((Object)this.getVersion());
        return builder.toHashCode();
    }

    public String toString() {
        return this.getId() + '-' + this.getVersion();
    }

    @Override
    public int compareTo(ExtensionId o) {
        if (o == null) {
            return -1;
        }
        CompareToBuilder builder = new CompareToBuilder();
        builder.append((Object)this.getId(), (Object)o.getId());
        builder.append((Object)this.getVersion(), (Object)o.getVersion());
        return builder.toComparison();
    }
}

