/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.internal.AbstractInstallPlanJob;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlan;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanAction;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanNode;
import org.xwiki.job.Job;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.logging.marker.TranslationMarker;

public abstract class AbstractExtensionPlanJob<R extends ExtensionRequest>
extends AbstractExtensionJob<R, DefaultExtensionPlan<R>> {
    protected static final TranslationMarker LOG_RESOLVE = new TranslationMarker("extension.log.job.plan.resolve");
    protected static final TranslationMarker LOG_RESOLVE_NAMESPACE = new TranslationMarker("extension.log.job.plan.resolve.namespace");
    protected static final TranslationMarker LOG_RESOLVEDEPENDENCY = new TranslationMarker("extension.log.job.plan.resolvedependency");
    protected static final TranslationMarker LOG_RESOLVEDEPENDENCY_NAMESPACE = new TranslationMarker("extension.log.job.plan.resolvedependency.namespace");
    private static final String EXCEPTION_NOTINSTALLED = "Extension [%s] is not installed";
    private static final String EXCEPTION_NOTINSTALLEDNAMESPACE = "Extension [%s] is not installed on namespace [%s]";
    protected AbstractInstallPlanJob.ModifableExtensionPlanTree extensionTree = new AbstractInstallPlanJob.ModifableExtensionPlanTree();

    protected DefaultExtensionPlan<R> createNewStatus(R request) {
        Job currentJob = this.jobContext.getCurrentJob();
        JobStatus currentJobStatus = currentJob != null ? currentJob.getStatus() : null;
        return new DefaultExtensionPlan<R>(request, this.observationManager, this.loggerManager, this.extensionTree, currentJobStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallExtension(String extensionId, Collection<String> namespaces, Collection<ExtensionPlanNode> parentBranch, boolean withBackWard) throws UninstallException {
        this.progressManager.pushLevelProgress(namespaces.size(), (Object)this);
        try {
            for (String namespace : namespaces) {
                this.progressManager.startStep((Object)this);
                this.uninstallExtension(extensionId, namespace, parentBranch, withBackWard);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected void uninstallExtension(String extensionId, String namespace, Collection<ExtensionPlanNode> parentBranch, boolean withBackWard) throws UninstallException {
        InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionId, namespace);
        if (installedExtension == null) {
            throw new UninstallException(String.format(EXCEPTION_NOTINSTALLED, extensionId));
        }
        try {
            this.uninstallExtension(installedExtension, namespace, parentBranch, withBackWard);
        }
        catch (Exception e) {
            throw new UninstallException("Failed to uninstall extension", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallExtension(InstalledExtension installedExtension, Collection<String> namespaces, Collection<ExtensionPlanNode> parentBranch, boolean withBackWard) throws UninstallException {
        this.progressManager.pushLevelProgress(namespaces.size(), (Object)this);
        try {
            for (String namespace : namespaces) {
                this.progressManager.startStep((Object)this);
                this.uninstallExtension(installedExtension, namespace, parentBranch, withBackWard);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallExtensions(Collection<InstalledExtension> extensions, String namespace, Collection<ExtensionPlanNode> parentBranch, boolean withBackWard) throws UninstallException {
        this.progressManager.pushLevelProgress(extensions.size(), (Object)this);
        try {
            for (InstalledExtension backardDependency : extensions) {
                this.progressManager.startStep((Object)this);
                this.uninstallExtension(backardDependency, namespace, parentBranch, withBackWard);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected void uninstallExtension(InstalledExtension installedExtension, String namespace, Collection<ExtensionPlanNode> parentBranch, boolean withBackWard) throws UninstallException {
        ExtensionHandler extensionHandler;
        if (!(namespace == null || installedExtension.getNamespaces() != null && installedExtension.getNamespaces().contains(namespace))) {
            throw new UninstallException(String.format(EXCEPTION_NOTINSTALLEDNAMESPACE, installedExtension, namespace));
        }
        try {
            extensionHandler = (ExtensionHandler)this.componentManager.getInstance(ExtensionHandler.class, installedExtension.getType());
        }
        catch (ComponentLookupException e) {
            throw new UninstallException(String.format("Unsupported type [%s]", installedExtension.getType()), e);
        }
        extensionHandler.checkUninstall(installedExtension, namespace, this.getRequest());
        if (((ExtensionRequest)this.getRequest()).isVerbose()) {
            if (namespace != null) {
                this.logger.info((Marker)LOG_RESOLVE_NAMESPACE, "Resolving extension [{}] from namespace [{}]", (Object)installedExtension.getId(), (Object)namespace);
            } else {
                this.logger.info((Marker)LOG_RESOLVE, "Resolving extension [{}]", (Object)installedExtension.getId());
            }
        }
        ArrayList<ExtensionPlanNode> children = new ArrayList<ExtensionPlanNode>();
        if (withBackWard) {
            this.uninstallBackwardDependencies(installedExtension, namespace, children, withBackWard);
        }
        DefaultExtensionPlanAction action = new DefaultExtensionPlanAction(installedExtension, Collections.singleton(installedExtension), ExtensionPlanAction.Action.UNINSTALL, namespace, false);
        parentBranch.add(new DefaultExtensionPlanNode(action, children, null));
    }

    protected void uninstallBackwardDependencies(InstalledExtension installedExtension, String namespace, List<ExtensionPlanNode> parentBranch, boolean withBackWard) throws UninstallException {
        try {
            if (namespace != null) {
                Collection<InstalledExtension> installedExtensions = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace);
                if (!installedExtensions.isEmpty()) {
                    this.uninstallExtensions(installedExtensions, namespace, parentBranch, withBackWard);
                }
            } else {
                this.uninstallBackwardDependencies(installedExtension, parentBranch, withBackWard);
            }
        }
        catch (ResolveException e) {
            throw new UninstallException("Failed to resolve backward dependencies of extension [" + installedExtension + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallBackwardDependencies(InstalledExtension installedExtension, List<ExtensionPlanNode> parentBranch, boolean withBackWard) throws UninstallException, ResolveException {
        Map<String, Collection<InstalledExtension>> backwardDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId());
        this.progressManager.pushLevelProgress(backwardDependencies.size(), (Object)this);
        try {
            for (Map.Entry<String, Collection<InstalledExtension>> entry : backwardDependencies.entrySet()) {
                this.progressManager.startStep((Object)this);
                this.uninstallExtensions(entry.getValue(), entry.getKey(), parentBranch, withBackWard);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }
}

