/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.history.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.job.history.ExtensionJobHistoryRecord;
import org.xwiki.extension.job.history.QuestionRecorder;
import org.xwiki.extension.job.history.ReplayJobStatus;
import org.xwiki.job.event.status.QuestionAskedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="AnswerReplayer")
@Singleton
public class AnswerReplayer
implements EventListener {
    public static final String NAME = "AnswerReplayer";
    private static final List<Event> EVENTS = Collections.singletonList(new QuestionAskedEvent());

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        if (source instanceof ReplayJobStatus) {
            this.replayAnswer((QuestionAskedEvent)event, (ReplayJobStatus)((Object)source));
        }
    }

    private void replayAnswer(QuestionAskedEvent event, ReplayJobStatus replayJobStatus) {
        QuestionRecorder<Object> answers;
        Object question = replayJobStatus.getQuestion();
        ExtensionJobHistoryRecord currentRecord = replayJobStatus.getCurrentRecord();
        if (question != null && currentRecord != null && (answers = currentRecord.getAnswers().get(question.getClass().getName())) != null && answers.replay(question)) {
            event.answered();
        }
    }
}

