/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.Extension;
import org.xwiki.extension.repository.internal.SortClauseComparator;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;

public final class RepositoryUtils {
    public static final String SEARCH_PATTERN_SUFFIXNPREFIX = ".*";

    private RepositoryUtils() {
    }

    public static CollectionIterableResult<Extension> searchInCollection(String pattern, int offset, int nb, Collection<? extends Extension> extensions) {
        return RepositoryUtils.searchInCollection(pattern, offset, nb, extensions, false);
    }

    public static CollectionIterableResult<Extension> searchInCollection(String pattern, int offset, int nb, Collection<? extends Extension> extensions, boolean forceUnique) {
        ExtensionQuery query = new ExtensionQuery(pattern);
        query.setOffset(offset);
        query.setLimit(nb);
        return RepositoryUtils.searchInCollection(query, extensions, forceUnique);
    }

    public static CollectionIterableResult<Extension> searchInCollection(ExtensionQuery query, Collection<? extends Extension> extensions, boolean forceUnique) {
        List<Extension> result = StringUtils.isEmpty((CharSequence)query.getQuery()) ? (extensions instanceof List ? (List<Extension>)extensions : new ArrayList<Extension>(extensions)) : RepositoryUtils.filter(query.getQuery(), query.getFilters(), extensions, forceUnique);
        RepositoryUtils.sort(result, query.getSortClauses());
        return RepositoryUtils.getIterableResult(query.getOffset(), query.getLimit(), result);
    }

    public static <T> CollectionIterableResult<T> getIterableResult(int offset, int nb, Collection<T> elements) {
        if (nb == 0 || offset >= elements.size()) {
            return new CollectionIterableResult(elements.size(), offset, Collections.emptyList());
        }
        ArrayList<T> list = elements instanceof List ? (ArrayList<T>)elements : new ArrayList<T>(elements);
        return RepositoryUtils.getIterableResultFromList(offset, nb, list);
    }

    private static <T> CollectionIterableResult<T> getIterableResultFromList(int offset, int nb, List<T> elements) {
        int toIndex;
        int fromIndex = offset;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (nb > 0) {
            toIndex = nb + fromIndex;
            if (toIndex > elements.size()) {
                toIndex = elements.size();
            }
        } else {
            toIndex = elements.size();
        }
        return new CollectionIterableResult<T>(elements.size(), offset, elements.subList(fromIndex, toIndex));
    }

    private static List<Extension> filter(String pattern, Collection<ExtensionQuery.Filter> filters, Collection<? extends Extension> extensions, boolean forceUnique) {
        ArrayList<Extension> result = new ArrayList<Extension>(extensions.size());
        Pattern patternMatcher = Pattern.compile(SEARCH_PATTERN_SUFFIXNPREFIX + pattern.toLowerCase() + SEARCH_PATTERN_SUFFIXNPREFIX);
        for (Extension extension : extensions) {
            if (!RepositoryUtils.matches(patternMatcher, filters, extension)) continue;
            result.add(extension);
        }
        if (forceUnique && result.size() > 1) {
            result = new ArrayList<Extension>(new LinkedHashSet<Extension>(result));
        }
        return result;
    }

    public static boolean matches(Pattern patternMatcher, Collection<ExtensionQuery.Filter> filters, Extension extension) {
        if (RepositoryUtils.matches(patternMatcher, extension.getId().getId(), extension.getDescription(), extension.getSummary(), extension.getName(), extension.getFeatures())) {
            for (ExtensionQuery.Filter filter : filters) {
                if (RepositoryUtils.matches(filter, extension)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object getValue(Extension extension, String field) {
        switch (field.toLowerCase()) {
            case "id": {
                return extension.getId().getId();
            }
            case "version": {
                return extension.getId().getVersion();
            }
            case "feature": 
            case "features": {
                return extension.getFeatures();
            }
            case "summary": {
                return extension.getSummary();
            }
            case "description": {
                return extension.getDescription();
            }
            case "author": 
            case "authors": {
                return extension.getAuthors();
            }
            case "category": {
                return extension.getCategory();
            }
            case "license": 
            case "licenses": {
                return extension.getLicenses();
            }
            case "name": {
                return extension.getName();
            }
            case "type": {
                return extension.getType();
            }
            case "website": {
                return extension.getWebSite();
            }
            case "scm": {
                return extension.getScm();
            }
        }
        return extension.getProperty(field);
    }

    public static boolean matches(ExtensionQuery.Filter filter, Extension extension) {
        Object value = RepositoryUtils.getValue(extension, filter.getField());
        if (value != null) {
            return RepositoryUtils.matches(filter, value);
        }
        return true;
    }

    public static boolean matches(ExtensionQuery.Filter filter, Object element) {
        if (filter.getValue() instanceof String) {
            Pattern patternMatcher;
            String value = (String)filter.getValue();
            return filter.getComparison() == ExtensionQuery.COMPARISON.MATCH ? RepositoryUtils.matches(patternMatcher = RepositoryUtils.createPatternMatcher(value), element) : filter.getComparison() == ExtensionQuery.COMPARISON.EQUAL && element != null && value.toLowerCase().equals(element.toString().toLowerCase());
        }
        return true;
    }

    public static boolean matches(Pattern patternMatcher, Object ... elements) {
        for (Object element : elements) {
            if (!RepositoryUtils.matches(patternMatcher, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Pattern patternMatcher, Object element) {
        return element != null && patternMatcher.matcher(element.toString().toLowerCase()).matches();
    }

    public static Pattern createPatternMatcher(String pattern) {
        return StringUtils.isEmpty((CharSequence)pattern) ? null : Pattern.compile(SEARCH_PATTERN_SUFFIXNPREFIX + Pattern.quote(pattern.toLowerCase()) + SEARCH_PATTERN_SUFFIXNPREFIX);
    }

    public static void sort(List<? extends Extension> extensions, Collection<ExtensionQuery.SortClause> sortClauses) {
        Collections.sort(extensions, new SortClauseComparator(sortClauses));
    }
}

