/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.internal.AbstractCachedExtensionRepository;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.internal.installed.DefaultInstalledExtension;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;

@Component
@Singleton
public class DefaultInstalledExtensionRepository
extends AbstractCachedExtensionRepository<DefaultInstalledExtension>
implements InstalledExtensionRepository,
Initializable {
    @Inject
    private transient LocalExtensionRepository localRepository;
    @Inject
    private transient CoreExtensionRepository coreExtensionRepository;
    @Inject
    private transient Logger logger;
    private Map<String, Map<String, InstalledFeature>> extensionNamespaceByFeature = new ConcurrentHashMap<String, Map<String, InstalledFeature>>();
    private Map<String, Map<String, Set<LocalExtension>>> localInstalledExtensionsCache;

    public void initialize() throws InitializationException {
        this.setDescriptor(new DefaultExtensionRepositoryDescriptor("installed", "installed", this.localRepository.getDescriptor().getURI()));
        this.localInstalledExtensionsCache = new HashMap<String, Map<String, Set<LocalExtension>>>();
        for (LocalExtension localExtension : this.localRepository.getLocalExtensions()) {
            if (!DefaultInstalledExtension.isInstalled(localExtension)) continue;
            this.addInstalledLocalExtension(localExtension);
        }
        for (LocalExtension localExtension : this.localRepository.getLocalExtensions()) {
            if (!DefaultInstalledExtension.isInstalled(localExtension)) continue;
            this.validateExtension(localExtension);
        }
        this.localInstalledExtensionsCache = null;
    }

    private void addInstalledLocalExtension(LocalExtension localExtension) {
        this.addInstalledLocalExtension(localExtension.getId().getId(), localExtension);
        for (String feature : localExtension.getFeatures()) {
            this.addInstalledLocalExtension(feature, localExtension);
        }
    }

    private void addInstalledLocalExtension(String feature, LocalExtension localExtension) {
        Collection<String> namespaces = DefaultInstalledExtension.getNamespaces(localExtension);
        if (namespaces == null) {
            this.addInstalledLocalExtension(feature, null, localExtension);
        } else {
            for (String namespace : namespaces) {
                this.addInstalledLocalExtension(feature, namespace, localExtension);
            }
        }
    }

    private void addInstalledLocalExtension(String feature, String namespace, LocalExtension localExtension) {
        Set<LocalExtension> localInstallExtensionNamespace;
        Map<String, Set<LocalExtension>> localInstallExtensionFeature = this.localInstalledExtensionsCache.get(feature);
        if (localInstallExtensionFeature == null) {
            localInstallExtensionFeature = new HashMap<String, Set<LocalExtension>>();
            this.localInstalledExtensionsCache.put(feature, localInstallExtensionFeature);
        }
        if ((localInstallExtensionNamespace = localInstallExtensionFeature.get(namespace)) == null) {
            localInstallExtensionNamespace = new HashSet<LocalExtension>();
            localInstallExtensionFeature.put(namespace, localInstallExtensionNamespace);
        }
        localInstallExtensionNamespace.add(localExtension);
    }

    private void validateExtension(LocalExtension localExtension) {
        Collection<String> namespaces = DefaultInstalledExtension.getNamespaces(localExtension);
        if (namespaces == null) {
            try {
                this.validateExtension(localExtension, null);
            }
            catch (InvalidExtensionException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Invalid extension [{}]", (Object)localExtension.getId(), (Object)e);
                } else {
                    this.logger.warn("Invalid extension [{}] ({})", (Object)localExtension.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                this.addInstalledExtension(localExtension, null, false);
            }
        } else {
            for (String namespace : namespaces) {
                try {
                    this.validateExtension(localExtension, namespace);
                }
                catch (InvalidExtensionException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("Invalid extension [{}] on namespace [{}]", new Object[]{localExtension.getId(), namespace, e});
                    } else {
                        this.logger.warn("Invalid extension [{}] on namespace [{}] ({})", new Object[]{localExtension.getId(), namespace, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                    }
                    this.addInstalledExtension(localExtension, namespace, false);
                }
            }
        }
    }

    private LocalExtension getInstalledLocalExtension(ExtensionDependency dependency, String namespace) {
        Set<LocalExtension> localInstallExtensionNamespace;
        Map<String, Set<LocalExtension>> localInstallExtensionFeature = this.localInstalledExtensionsCache.get(dependency.getId());
        if (localInstallExtensionFeature != null && (localInstallExtensionNamespace = localInstallExtensionFeature.get(namespace)) != null) {
            for (LocalExtension dependencyVersion : localInstallExtensionNamespace) {
                if (!this.isCompatible(dependencyVersion.getId().getVersion(), dependency.getVersionConstraint())) continue;
                return dependencyVersion;
            }
        }
        if (namespace != null) {
            return this.getInstalledLocalExtension(dependency, null);
        }
        return null;
    }

    private void validateDependency(ExtensionDependency dependency, String namespace) throws InvalidExtensionException {
        CoreExtension coreExtension = this.coreExtensionRepository.getCoreExtension(dependency.getId());
        if (coreExtension != null) {
            if (!this.isCompatible(coreExtension.getId().getVersion(), dependency.getVersionConstraint())) {
                throw new InvalidExtensionException(String.format("Dependency [%s] is incompatible with the core extension [%s]", dependency, coreExtension));
            }
        } else {
            LocalExtension dependencyExtension;
            LocalExtension localExtension = dependencyExtension = this.localInstalledExtensionsCache != null ? this.getInstalledLocalExtension(dependency, namespace) : this.getInstalledExtension(dependency.getId(), namespace);
            if (dependencyExtension == null) {
                throw new InvalidExtensionException(String.format("No compatible extension is installed for dependency [%s]", dependency));
            }
            try {
                DefaultInstalledExtension installedExtension = this.validateExtension(dependencyExtension, namespace);
                if (!installedExtension.isValid(namespace)) {
                    throw new InvalidExtensionException(String.format("Extension dependency [%s] is invalid", installedExtension.getId()));
                }
            }
            catch (InvalidExtensionException e) {
                if (this.localInstalledExtensionsCache != null) {
                    this.addInstalledExtension(dependencyExtension, namespace, false);
                }
                throw e;
            }
        }
    }

    private DefaultInstalledExtension validateExtension(LocalExtension localExtension, String namespace) throws InvalidExtensionException {
        InstalledFeature feature = this.getInstalledFeatureFromCache(localExtension.getId().getId(), namespace);
        if (feature != null && feature.root.extension != null) {
            return feature.root.extension;
        }
        if (namespace != null && DefaultInstalledExtension.getNamespaces(localExtension) == null) {
            return this.validateExtension(localExtension, null);
        }
        if (!DefaultInstalledExtension.isInstalled(localExtension, namespace)) {
            throw new InvalidExtensionException(String.format("Extension [%s] is not installed", localExtension));
        }
        if (this.coreExtensionRepository.exists(localExtension.getId().getId())) {
            throw new InvalidExtensionException(String.format("Extension [%s] already exists as a core extension", localExtension));
        }
        InvalidExtensionException dependencyException = null;
        for (ExtensionDependency extensionDependency : localExtension.getDependencies()) {
            try {
                this.validateDependency(extensionDependency, namespace);
            }
            catch (InvalidExtensionException e) {
                if (dependencyException != null) continue;
                dependencyException = e;
            }
        }
        if (dependencyException != null) {
            throw dependencyException;
        }
        return localExtension instanceof DefaultInstalledExtension ? (DefaultInstalledExtension)localExtension : this.addInstalledExtension(localExtension, namespace, true);
    }

    private boolean isValid(DefaultInstalledExtension installedExtension, String namespace) {
        try {
            this.validateExtension(installedExtension, namespace);
            return true;
        }
        catch (InvalidExtensionException e) {
            this.logger.debug("Invalid extension [{}] on namespace [{}]", new Object[]{installedExtension.getId(), namespace, e});
            return false;
        }
    }

    private boolean isCompatible(Version existingVersion, VersionConstraint versionConstraint) {
        boolean compatible = true;
        compatible = versionConstraint.getVersion() == null ? versionConstraint.containsVersion(existingVersion) : existingVersion.compareTo(versionConstraint.getVersion()) >= 0;
        return compatible;
    }

    private void removeInstalledExtension(DefaultInstalledExtension installedExtension, String namespace) {
        this.removeInstalledFeature(installedExtension.getId().getId(), namespace);
        for (String feature : installedExtension.getFeatures()) {
            this.removeInstalledFeature(feature, namespace);
        }
        this.removeFromBackwardDependencies(installedExtension, namespace);
        if (!installedExtension.isInstalled()) {
            this.removeCachedExtension(installedExtension);
        }
    }

    private void removeInstalledFeature(String feature, String namespace) {
        if (namespace == null) {
            this.extensionNamespaceByFeature.remove(feature);
        } else {
            Map<String, InstalledFeature> namespaceInstalledExtension = this.extensionNamespaceByFeature.get(feature);
            namespaceInstalledExtension.remove(namespace);
        }
    }

    private void applyInstallExtension(DefaultInstalledExtension installedExtension, String namespace, boolean dependency) throws InstallException {
        installedExtension.setInstalled(true, namespace);
        installedExtension.setDependency(dependency, namespace);
        try {
            this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
        }
        catch (Exception e) {
            throw new InstallException("Failed to modify extension descriptor", e);
        }
        installedExtension.setValid(namespace, this.isValid(installedExtension, namespace));
        this.addInstalledExtension(installedExtension, namespace);
    }

    private void removeFromBackwardDependencies(DefaultInstalledExtension installedExtension, String namespace) {
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            InstalledFeature installedFeature;
            if (this.coreExtensionRepository.getCoreExtension(dependency.getId()) != null || (installedFeature = this.getInstalledFeatureFromCache(dependency.getId(), namespace)) == null) continue;
            installedFeature.root.backwardDependencies.remove(installedExtension);
        }
    }

    private DefaultInstalledExtension addInstalledExtension(LocalExtension localExtension, String namespace, boolean valid) {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.extensions.get(localExtension.getId());
        if (installedExtension == null) {
            installedExtension = new DefaultInstalledExtension(localExtension, this);
        }
        installedExtension.setInstalled(true, namespace);
        installedExtension.setValid(namespace, valid);
        this.addInstalledExtension(installedExtension, namespace);
        return installedExtension;
    }

    private void addInstalledExtension(DefaultInstalledExtension installedExtension, String namespace) {
        this.addCachedExtension(installedExtension);
        this.addInstalledFeatureToCache(installedExtension.getId().getId(), namespace, installedExtension);
        for (String feature : installedExtension.getFeatures()) {
            this.addInstalledFeatureToCache(feature, namespace, installedExtension);
        }
        this.updateMissingBackwardDependencies();
    }

    private void updateMissingBackwardDependencies() {
        for (DefaultInstalledExtension installedExtension : this.extensions.values()) {
            this.updateMissingBackwardDependencies(installedExtension);
        }
    }

    private void updateMissingBackwardDependencies(DefaultInstalledExtension installedExtension) {
        Collection<String> namespaces = installedExtension.getNamespaces();
        if (namespaces == null) {
            if (installedExtension.isValid(null)) {
                this.updateMissingBackwardDependencies(installedExtension, null);
            }
        } else {
            for (String namespace : namespaces) {
                if (!installedExtension.isValid(namespace)) continue;
                this.updateMissingBackwardDependencies(installedExtension, namespace);
            }
        }
    }

    private void updateMissingBackwardDependencies(DefaultInstalledExtension installedExtension, String namespace) {
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            DefaultInstalledExtension dependencyLocalExtension;
            if (this.coreExtensionRepository.exists(dependency.getId()) || (dependencyLocalExtension = (DefaultInstalledExtension)this.getInstalledExtension(dependency.getId(), namespace)) == null) continue;
            InstalledFeature dependencyInstalledExtension = this.addInstalledFeatureToCache(dependency.getId(), namespace, dependencyLocalExtension);
            dependencyInstalledExtension.root.backwardDependencies.add(installedExtension);
        }
    }

    private InstalledFeature addInstalledFeatureToCache(String feature, String namespace, DefaultInstalledExtension localExtension) {
        InstalledFeature installedFeature;
        Map<String, InstalledFeature> installedExtensionsForFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsForFeature == null) {
            installedExtensionsForFeature = new HashMap<String, InstalledFeature>();
            this.extensionNamespaceByFeature.put(feature, installedExtensionsForFeature);
        }
        if ((installedFeature = installedExtensionsForFeature.get(namespace)) == null) {
            InstalledRootFeature rootFeature = localExtension.getId().getId().equals(feature) ? new InstalledRootFeature(namespace) : this.getInstalledFeatureFromCache((String)localExtension.getId().getId(), (String)namespace).root;
            installedFeature = new InstalledFeature(rootFeature, feature);
            installedExtensionsForFeature.put(namespace, installedFeature);
        }
        if (localExtension.isValid(namespace)) {
            installedFeature.root.extension = localExtension;
        } else {
            installedFeature.root.invalidExtensions.add(localExtension);
        }
        return installedFeature;
    }

    private InstalledFeature getInstalledFeatureFromCache(String feature, String namespace) {
        if (feature == null) {
            return null;
        }
        Map<String, InstalledFeature> installedExtensionsForFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsForFeature == null) {
            return null;
        }
        InstalledFeature installedExtension = installedExtensionsForFeature.get(namespace);
        if (installedExtension == null && namespace != null) {
            installedExtension = this.getInstalledFeatureFromCache(feature, null);
        }
        return installedExtension;
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        ArrayList<InstalledExtension> result = new ArrayList<InstalledExtension>(this.extensions.size());
        for (InstalledExtension installedExtension : this.extensions.values()) {
            if (!installedExtension.isInstalled(namespace)) continue;
            result.add(installedExtension);
        }
        return result;
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public InstalledExtension getInstalledExtension(ExtensionId extensionId) {
        return (InstalledExtension)this.extensions.get(extensionId);
    }

    @Override
    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        InstalledFeature installedFeature = this.getInstalledFeatureFromCache(feature, namespace);
        if (installedFeature != null) {
            if (installedFeature.root.extension != null) {
                return installedFeature.root.extension;
            }
            return installedFeature.root.invalidExtensions.isEmpty() ? null : installedFeature.root.invalidExtensions.iterator().next();
        }
        return null;
    }

    @Override
    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.extensions.get(extension.getId());
        if (installedExtension != null && installedExtension.isInstalled(namespace)) {
            if (installedExtension.isDependency() == dependency) {
                throw new InstallException(String.format("The extension [%s] is already installed on namespace [%s]", installedExtension, namespace));
            }
            installedExtension.setDependency(dependency, namespace);
            try {
                this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
            }
            catch (Exception e) {
                throw new InstallException("Failed to modify extension descriptor", e);
            }
        } else {
            LocalExtension localExtension = this.localRepository.getLocalExtension(extension.getId());
            if (localExtension == null) {
                throw new InstallException(String.format("The extension [%s] need to be stored first", extension));
            }
            if (installedExtension == null) {
                installedExtension = new DefaultInstalledExtension(localExtension, this);
            }
            this.applyInstallExtension(installedExtension, namespace, dependency);
        }
        return installedExtension;
    }

    @Override
    public void uninstallExtension(InstalledExtension extension, String namespace) throws UninstallException {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.getInstalledExtension(extension.getId().getId(), namespace);
        if (installedExtension != null) {
            this.applyUninstallExtension(installedExtension, namespace);
        }
    }

    private void applyUninstallExtension(DefaultInstalledExtension installedExtension, String namespace) throws UninstallException {
        installedExtension.setInstalled(false, namespace);
        try {
            this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
        }
        catch (Exception e) {
            throw new UninstallException("Failed to modify extension descriptor", e);
        }
        this.removeInstalledExtension(installedExtension, namespace);
    }

    @Override
    public Collection<InstalledExtension> getBackwardDependencies(String feature, String namespace) throws ResolveException {
        InstalledFeature installedExtension;
        if (this.getInstalledExtension(feature, namespace) == null) {
            throw new ResolveException(String.format("Extension [%s] is not installed on namespace [%s]", feature, namespace));
        }
        Map<String, InstalledFeature> installedExtensionsByFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsByFeature != null && (installedExtension = installedExtensionsByFeature.get(namespace)) != null) {
            Set<DefaultInstalledExtension> backwardDependencies = installedExtension.root.backwardDependencies;
            return backwardDependencies != null ? new ArrayList<DefaultInstalledExtension>(backwardDependencies) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        Map<String, Collection<InstalledExtension>> result;
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.resolve(extensionId);
        Collection<String> namespaces = installedExtension.getNamespaces();
        Map<String, InstalledFeature> featureExtensions = this.extensionNamespaceByFeature.get(installedExtension.getId().getId());
        if (featureExtensions != null) {
            result = new HashMap();
            for (InstalledFeature festureExtension : featureExtensions.values()) {
                if (namespaces != null && !namespaces.contains(festureExtension.root.namespace) || festureExtension.root.backwardDependencies.isEmpty()) continue;
                result.put(festureExtension.root.namespace, new ArrayList<DefaultInstalledExtension>(festureExtension.root.backwardDependencies));
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    @Override
    public IterableResult<Extension> searchInstalledExtensions(String pattern, String namespace, int offset, int nb) throws SearchException {
        Pattern patternMatcher = StringUtils.isEmpty((CharSequence)pattern) ? null : Pattern.compile(".*" + Pattern.quote(pattern.toLowerCase()) + ".*");
        HashSet<InstalledExtension> set = new HashSet<InstalledExtension>();
        ArrayList<InstalledExtension> result = new ArrayList<InstalledExtension>(this.extensionsVersions.size());
        for (InstalledExtension installedExtension : this.extensions.values()) {
            if (!installedExtension.isInstalled(namespace) || patternMatcher != null && !RepositoryUtils.matches(patternMatcher, installedExtension) || set.contains(installedExtension)) continue;
            result.add(installedExtension);
            set.add(installedExtension);
        }
        return RepositoryUtils.getIterableResult(offset, nb, result);
    }

    private static class InstalledFeature {
        public InstalledRootFeature root;
        public String feature;

        public InstalledFeature(InstalledRootFeature root, String feature) {
            this.root = root;
            this.feature = feature;
        }
    }

    private static class InstalledRootFeature {
        public DefaultInstalledExtension extension;
        public Set<DefaultInstalledExtension> invalidExtensions = new HashSet<DefaultInstalledExtension>();
        public String namespace;
        public Set<DefaultInstalledExtension> backwardDependencies = new HashSet<DefaultInstalledExtension>();

        public InstalledRootFeature(String namespace) {
            this.namespace = namespace;
        }
    }
}

