/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.core;

import java.net.URL;
import java.util.Map;
import org.apache.maven.model.Model;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.repository.internal.MavenExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;

public class MavenCoreExtension
extends DefaultCoreExtension
implements MavenExtension {
    private static final String PKEY_MAVEN_ARTIFACTID = "maven.artifactId";
    private static final String PKEY_MAVEN_GROUPID = "maven.groupId";

    public MavenCoreExtension(DefaultCoreExtensionRepository repository, URL url, ExtensionId id, String type, Model mavenModel) {
        super(repository, url, id, type);
        this.putProperty(PKEY_MAVEN_ARTIFACTID, mavenModel.getArtifactId());
        this.putProperty(PKEY_MAVEN_GROUPID, mavenModel.getGroupId());
        for (Map.Entry<Object, Object> entry : mavenModel.getProperties().entrySet()) {
            this.putProperty((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getMavenArtifactId() {
        return (String)this.getProperty(PKEY_MAVEN_ARTIFACTID);
    }

    @Override
    public String getMavenGroupId() {
        return (String)this.getProperty(PKEY_MAVEN_GROUPID);
    }
}

