/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.result;

import java.util.Iterator;

public class AggregatedIterator<T>
implements Iterator<T> {
    private Iterator<Iterator<T>> iterators;
    private Iterator<T> currentIterator;

    public AggregatedIterator(Iterator<Iterator<T>> iterators) {
        this.iterators = iterators;
        this.currentIterator = iterators.next();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.currentIterator.hasNext();
        if (!hasNext && this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
            hasNext = this.currentIterator.hasNext();
        }
        return hasNext;
    }

    @Override
    public T next() {
        boolean hasNext = this.currentIterator.hasNext();
        if (!hasNext && this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
        }
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
        if (!this.currentIterator.hasNext() && this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
        }
    }
}

