/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;

public class DefaultExtensionRepositoryDescriptor
implements ExtensionRepositoryDescriptor {
    private final String id;
    private final String type;
    private final URI uri;
    private Map<String, String> properties = new HashMap<String, String>();

    public DefaultExtensionRepositoryDescriptor(ExtensionRepositoryDescriptor descriptor) {
        this(descriptor.getId(), descriptor.getType(), descriptor.getURI());
        this.setProperties(descriptor.getProperties());
    }

    public DefaultExtensionRepositoryDescriptor(String id, String type, URI uri) {
        this.id = id;
        this.type = type;
        this.uri = uri;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void putProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtensionRepositoryDescriptor) {
            ExtensionRepositoryDescriptor extensionId = (ExtensionRepositoryDescriptor)obj;
            return this.getId().equals(extensionId.getId()) && this.getType().equals(extensionId.getType()) && this.getURI().equals(extensionId.getURI());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getId() + " (" + this.getURI() + ')';
    }
}

